/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import java.util.ArrayList;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.TstExpressionCase;
import org.apache.cayenne.exp.TstExpressionSuite;

public class TstBinaryExpSuite
extends TstExpressionSuite {
    private static final TstExpressionCase like1 = TstBinaryExpSuite.buildLike1();
    private static final TstExpressionCase likeic1 = TstBinaryExpSuite.buildLikeIgnoreCase1();
    private static final TstExpressionCase in1 = TstBinaryExpSuite.buildIn1();
    private static final TstExpressionCase in2 = TstBinaryExpSuite.buildIn2();
    private static final TstExpressionCase isNull = TstBinaryExpSuite.buildIsNull();
    private static final TstExpressionCase isNotNull = TstBinaryExpSuite.buildIsNotNull();

    private static TstExpressionCase buildIn1() {
        ArrayList<String> in = new ArrayList<String>();
        in.add("g1");
        in.add("g2");
        in.add("g3");
        Expression e1 = ExpressionFactory.expressionOfType(10);
        Expression e10 = ExpressionFactory.expressionOfType(26);
        e10.setOperand(0, "toGallery.galleryName");
        e1.setOperand(0, e10);
        Expression e11 = ExpressionFactory.expressionOfType(28);
        e11.setOperand(0, in);
        e1.setOperand(1, e11);
        return new TstExpressionCase("Exhibit", e1, "ta.GALLERY_NAME IN (?, ?, ?)", 3, 2);
    }

    private static TstExpressionCase buildIsNull() {
        Expression e1 = ExpressionFactory.expressionOfType(3);
        Expression e10 = ExpressionFactory.expressionOfType(26);
        e10.setOperand(0, "toGallery.galleryName");
        e1.setOperand(0, e10);
        e1.setOperand(1, null);
        return new TstExpressionCase("Exhibit", e1, "ta.GALLERY_NAME IS NULL", 2, 2);
    }

    private static TstExpressionCase buildIsNotNull() {
        Expression e1 = ExpressionFactory.expressionOfType(4);
        Expression e10 = ExpressionFactory.expressionOfType(26);
        e10.setOperand(0, "toGallery.galleryName");
        e1.setOperand(0, e10);
        e1.setOperand(1, null);
        return new TstExpressionCase("Exhibit", e1, "ta.GALLERY_NAME IS NOT NULL", 2, 2);
    }

    private static TstExpressionCase buildIn2() {
        Object[] in = new Object[]{"g1", "g2", "g3"};
        Expression e1 = ExpressionFactory.expressionOfType(10);
        Expression e10 = ExpressionFactory.expressionOfType(26);
        e10.setOperand(0, "toGallery.galleryName");
        e1.setOperand(0, e10);
        Expression e11 = ExpressionFactory.expressionOfType(28);
        e11.setOperand(0, in);
        e1.setOperand(1, e11);
        return new TstExpressionCase("Exhibit", e1, "ta.GALLERY_NAME IN (?, ?, ?)", 3, 2);
    }

    private static TstExpressionCase buildLike1() {
        Expression e1 = ExpressionFactory.expressionOfType(11);
        Expression e10 = ExpressionFactory.expressionOfType(26);
        e10.setOperand(0, "toGallery.galleryName");
        e1.setOperand(0, e10);
        e1.setOperand(1, "a%");
        return new TstExpressionCase("Exhibit", e1, "ta.GALLERY_NAME LIKE ?", 2, 2);
    }

    private static TstExpressionCase buildLikeIgnoreCase1() {
        Expression e1 = ExpressionFactory.expressionOfType(12);
        Expression e10 = ExpressionFactory.expressionOfType(26);
        e10.setOperand(0, "toGallery.galleryName");
        e1.setOperand(0, e10);
        e1.setOperand(1, "a%");
        return new TstExpressionCase("Exhibit", e1, "UPPER(ta.GALLERY_NAME) LIKE UPPER(?)", 2, 2);
    }

    public TstBinaryExpSuite() {
        this.addCase(like1);
        this.addCase(likeic1);
        this.addCase(in1);
        this.addCase(in2);
        this.addCase(isNull);
        this.addCase(isNotNull);
    }
}

