/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import java.util.HashMap;
import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ParsedExpQualifierCompatIT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tArtist;
    protected TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "ESTIMATED_PRICE"});
    }

    protected void createTwentyFiveArtists() throws Exception {
        for (int i = 1; i <= 25; ++i) {
            this.tArtist.insert(new Object[]{i, "artist" + i});
        }
    }

    protected void createTwentyFiveArtistsAndPaintings() throws Exception {
        this.createTwentyFiveArtists();
        for (int i = 1; i <= 25; ++i) {
            this.tPainting.insert(new Object[]{i, "p_artist" + i, i, i * 1000});
        }
    }

    private <T> List<T> execute(Class<T> root, Expression qualifier) {
        return this.execute(root, qualifier, null);
    }

    private <T> List<T> execute(Class<T> root, Expression qualifier, String prefecth) {
        SelectQuery<T> query = new SelectQuery<T>(root, qualifier);
        if (prefecth != null) {
            query.addPrefetch(prefecth);
        }
        return this.context.performQuery(query);
    }

    @Test
    public void testOr() throws Exception {
        this.createTwentyFiveArtists();
        Expression parsed = Expression.fromString("artistName='artist1' or artistName='artist3'");
        Assert.assertEquals((long)2L, (long)this.execute(Artist.class, parsed).size());
        parsed = Expression.fromString("artistName='artist1' or artistName='artist3' or artistName='artist5'");
        Assert.assertEquals((long)3L, (long)this.execute(Artist.class, parsed).size());
    }

    @Test
    public void testAnd() throws Exception {
        this.createTwentyFiveArtists();
        Expression parsed = Expression.fromString("artistName='artist1' and artistName='artist1'");
        Assert.assertEquals((long)1L, (long)this.execute(Artist.class, parsed).size());
        parsed = Expression.fromString("artistName='artist1' and artistName='artist3'");
        Assert.assertEquals((long)0L, (long)this.execute(Artist.class, parsed).size());
    }

    @Test
    public void testNot() throws Exception {
        this.createTwentyFiveArtists();
        Expression parsed1 = Expression.fromString("not artistName='artist3'");
        Assert.assertEquals((long)24L, (long)this.execute(Artist.class, parsed1).size());
        Expression parsed2 = Expression.fromString("not artistName='artist3'");
        Assert.assertEquals((long)24L, (long)this.execute(Artist.class, parsed2).size());
    }

    @Test
    public void testEqual() throws Exception {
        this.createTwentyFiveArtists();
        Expression parsed1 = Expression.fromString("artistName='artist3'");
        Assert.assertEquals((long)1L, (long)this.execute(Artist.class, parsed1).size());
        Assert.assertEquals((long)1L, (long)this.execute(Artist.class, parsed1, "paintingArray").size());
        Expression parsed2 = Expression.fromString("artistName=='artist3'");
        Assert.assertEquals((long)1L, (long)this.execute(Artist.class, parsed2).size());
    }

    @Test
    public void testNotEqual() throws Exception {
        this.createTwentyFiveArtists();
        Expression parsed1 = Expression.fromString("artistName!='artist3'");
        Assert.assertEquals((long)24L, (long)this.execute(Artist.class, parsed1).size());
        Expression parsed2 = Expression.fromString("artistName<>'artist3'");
        Assert.assertEquals((long)24L, (long)this.execute(Artist.class, parsed2).size());
    }

    @Test
    public void testLessThan() throws Exception {
        this.createTwentyFiveArtistsAndPaintings();
        Expression parsed1 = Expression.fromString("estimatedPrice < 2000.0");
        Assert.assertEquals((long)1L, (long)this.execute(Painting.class, parsed1).size());
    }

    @Test
    public void testLessThanEqualTo() throws Exception {
        this.createTwentyFiveArtistsAndPaintings();
        Expression parsed1 = Expression.fromString("estimatedPrice <= 2000.0");
        Assert.assertEquals((long)2L, (long)this.execute(Painting.class, parsed1).size());
    }

    @Test
    public void testGreaterThan() throws Exception {
        this.createTwentyFiveArtistsAndPaintings();
        Expression parsed1 = Expression.fromString("estimatedPrice > 2000");
        Assert.assertEquals((long)23L, (long)this.execute(Painting.class, parsed1).size());
    }

    @Test
    public void testGreaterThanEqualTo() throws Exception {
        this.createTwentyFiveArtistsAndPaintings();
        Expression parsed1 = Expression.fromString("estimatedPrice >= 2000");
        Assert.assertEquals((long)24L, (long)this.execute(Painting.class, parsed1).size());
    }

    @Test
    public void testLike() throws Exception {
        this.createTwentyFiveArtists();
        Expression parsed1 = Expression.fromString("artistName like 'artist%2'");
        Assert.assertEquals((long)3L, (long)this.execute(Artist.class, parsed1).size());
    }

    @Test
    public void testLikeIgnoreCase() throws Exception {
        this.createTwentyFiveArtists();
        Expression parsed1 = Expression.fromString("artistName likeIgnoreCase 'artist%2'");
        Assert.assertEquals((long)3L, (long)this.execute(Artist.class, parsed1).size());
    }

    @Test
    public void testNotLike() throws Exception {
        this.createTwentyFiveArtists();
        Expression parsed1 = Expression.fromString("artistName not like 'artist%2'");
        Assert.assertEquals((long)22L, (long)this.execute(Artist.class, parsed1).size());
    }

    @Test
    public void testNotLikeIgnoreCase() throws Exception {
        this.createTwentyFiveArtists();
        Expression parsed1 = Expression.fromString("artistName not likeIgnoreCase 'artist%2'");
        Assert.assertEquals((long)22L, (long)this.execute(Artist.class, parsed1).size());
    }

    @Test
    public void testIn() throws Exception {
        this.createTwentyFiveArtists();
        Expression parsed1 = Expression.fromString("artistName in ('artist1', 'artist3', 'artist19')");
        Assert.assertEquals((long)3L, (long)this.execute(Artist.class, parsed1).size());
    }

    @Test
    public void testNotIn() throws Exception {
        this.createTwentyFiveArtists();
        Expression parsed1 = Expression.fromString("artistName not in ('artist1', 'artist3', 'artist19')");
        Assert.assertEquals((long)22L, (long)this.execute(Artist.class, parsed1).size());
    }

    @Test
    public void testBetween() throws Exception {
        this.createTwentyFiveArtistsAndPaintings();
        Expression parsed1 = Expression.fromString("estimatedPrice between 2000.0 and 4000.0");
        Assert.assertEquals((long)3L, (long)this.execute(Painting.class, parsed1).size());
    }

    @Test
    public void testNotBetween() throws Exception {
        this.createTwentyFiveArtistsAndPaintings();
        Expression parsed1 = Expression.fromString("estimatedPrice not between 2000.0 and 4000.0");
        Assert.assertEquals((long)22L, (long)this.execute(Painting.class, parsed1).size());
    }

    @Test
    public void testParameter() throws Exception {
        this.createTwentyFiveArtists();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("artistName", "artist5");
        Expression parsed1 = Expression.fromString("artistName=$artistName");
        parsed1 = parsed1.expWithParameters(parameters);
        Assert.assertEquals((long)1L, (long)this.execute(Artist.class, parsed1).size());
    }

    @Test
    public void testDbExpression() throws Exception {
        this.createTwentyFiveArtists();
        Expression parsed1 = Expression.fromString("db:ARTIST_NAME='artist3'");
        Assert.assertEquals((long)1L, (long)this.execute(Artist.class, parsed1).size());
    }

    @Test
    public void testFloatExpression() throws Exception {
        this.createTwentyFiveArtistsAndPaintings();
        Expression parsed1 = Expression.fromString("estimatedPrice < 2001.01");
        Assert.assertEquals((long)2L, (long)this.execute(Painting.class, parsed1).size());
    }

    @Test
    public void testNullExpression() throws Exception {
        this.createTwentyFiveArtists();
        Expression parsed1 = Expression.fromString("artistName!=null");
        Assert.assertEquals((long)25L, (long)this.execute(Artist.class, parsed1).size());
        Expression parsed2 = Expression.fromString("artistName = null");
        Assert.assertEquals((long)0L, (long)this.execute(Artist.class, parsed2).size());
    }

    @Test
    public void testTrueExpression() throws Exception {
        this.createTwentyFiveArtistsAndPaintings();
        Expression parsed1 = Expression.fromString("true");
        Assert.assertEquals((long)25L, (long)this.execute(Painting.class, parsed1).size());
        Expression parsed2 = Expression.fromString("(estimatedPrice < 2001.01) and true");
        Assert.assertEquals((long)2L, (long)this.execute(Painting.class, parsed2).size());
        Expression parsed3 = Expression.fromString("(estimatedPrice < 2001.01) or true");
        Assert.assertEquals((long)25L, (long)this.execute(Painting.class, parsed3).size());
    }

    @Test
    public void testFalseExpression() throws Exception {
        this.createTwentyFiveArtistsAndPaintings();
        Expression parsed1 = Expression.fromString("false");
        Assert.assertEquals((long)0L, (long)this.execute(Painting.class, parsed1).size());
        Expression parsed2 = Expression.fromString("(estimatedPrice < 2001.01) and false");
        Assert.assertEquals((long)0L, (long)this.execute(Painting.class, parsed2).size());
        Expression parsed3 = Expression.fromString("(estimatedPrice < 2001.01) or false");
        Assert.assertEquals((long)2L, (long)this.execute(Painting.class, parsed3).size());
    }
}

