/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.event;

import java.util.Collection;
import org.apache.cayenne.access.event.SnapshotEvent;
import org.apache.cayenne.event.CayenneEvent;
import org.apache.cayenne.event.DefaultEventManager;
import org.apache.cayenne.event.EventBridge;
import org.apache.cayenne.event.EventSubject;
import org.apache.cayenne.test.parallel.ParallelTestContainer;
import org.junit.Assert;
import org.junit.Test;

public class EventBridgeTest {
    @Test
    public void testConstructor() throws Exception {
        EventSubject local = EventSubject.getSubject(EventBridgeTest.class, "testInstall");
        String external = "externalSubject";
        TestBridge bridge = new TestBridge(local, external);
        Collection<EventSubject> subjects = bridge.getLocalSubjects();
        Assert.assertEquals((long)1L, (long)subjects.size());
        Assert.assertTrue((boolean)subjects.contains(local));
        Assert.assertEquals((Object)external, (Object)bridge.getExternalSubject());
    }

    @Test
    public void testStartup() throws Exception {
        EventSubject local = EventSubject.getSubject(EventBridgeTest.class, "testInstall");
        String external = "externalSubject";
        TestBridge bridge = new TestBridge(local, external);
        DefaultEventManager manager = new DefaultEventManager();
        bridge.startup(manager, 3);
        Assert.assertSame((Object)manager, (Object)bridge.eventManager);
        Assert.assertEquals((long)1L, (long)bridge.startupCalls);
        Assert.assertEquals((long)0L, (long)bridge.shutdownCalls);
        DefaultEventManager newManager = new DefaultEventManager();
        bridge.startup(newManager, 3);
        Assert.assertSame((Object)newManager, (Object)bridge.eventManager);
        Assert.assertEquals((long)2L, (long)bridge.startupCalls);
        Assert.assertEquals((long)1L, (long)bridge.shutdownCalls);
    }

    @Test
    public void testShutdown() throws Exception {
        EventSubject local = EventSubject.getSubject(EventBridgeTest.class, "testInstall");
        String external = "externalSubject";
        TestBridge bridge = new TestBridge(local, external);
        DefaultEventManager manager = new DefaultEventManager();
        bridge.startup(manager, 3);
        bridge.shutdown();
        Assert.assertNull((Object)bridge.eventManager);
        Assert.assertEquals((long)1L, (long)bridge.startupCalls);
        Assert.assertEquals((long)1L, (long)bridge.shutdownCalls);
    }

    @Test
    public void testSendExternalEvent() throws Exception {
        final EventSubject local = EventSubject.getSubject(EventBridgeTest.class, "testInstall");
        String external = "externalSubject";
        final TestBridge bridge = new TestBridge(local, external);
        DefaultEventManager manager = new DefaultEventManager(2);
        bridge.startup(manager, 3);
        SnapshotEvent eventWithNoSubject = new SnapshotEvent(this, this, null, null, null, null);
        manager.postEvent(eventWithNoSubject, local);
        ParallelTestContainer helper = new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertTrue((boolean)(bridge.lastLocalEvent instanceof SnapshotEvent));
                Assert.assertEquals((Object)local, (Object)bridge.lastLocalEvent.getSubject());
            }
        };
        helper.runTest(5000L);
        SnapshotEvent eventWithSubject = new SnapshotEvent(this, this, null, null, null, null);
        eventWithSubject.setSubject(local);
        manager.postEvent(eventWithNoSubject, local);
        ParallelTestContainer helper1 = new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertTrue((boolean)(bridge.lastLocalEvent instanceof SnapshotEvent));
                Assert.assertEquals((Object)local, (Object)bridge.lastLocalEvent.getSubject());
            }
        };
        helper1.runTest(5000L);
    }

    class TestBridge
    extends EventBridge {
        CayenneEvent lastLocalEvent;
        int startupCalls;
        int shutdownCalls;

        public TestBridge(EventSubject localSubject, String externalSubject) {
            super(localSubject, externalSubject);
        }

        @Override
        public void sendExternalEvent(CayenneEvent event) {
            this.lastLocalEvent = event;
        }

        @Override
        protected void shutdownExternal() throws Exception {
            ++this.shutdownCalls;
        }

        @Override
        protected void startupExternal() throws Exception {
            ++this.startupCalls;
        }
    }
}

