/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ejbql;

import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.ejbql.EJBQLCompiledExpression;
import org.apache.cayenne.ejbql.EJBQLParser;
import org.apache.cayenne.ejbql.EJBQLParserFactory;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class EJBQLCompiledExpressionIT
extends ServerCase {
    @Inject
    protected ServerRuntime runtime;

    @Test
    public void testGetSource() {
        String source = "select a from Artist a";
        EntityResolver resolver = this.runtime.getDataDomain().getEntityResolver();
        EJBQLParser parser = EJBQLParserFactory.getParser();
        EJBQLCompiledExpression select = parser.compile(source, resolver);
        Assert.assertEquals((Object)source, (Object)select.getSource());
    }

    @Test
    public void testGetExpression() {
        String source = "select a from Artist a";
        EntityResolver resolver = this.runtime.getDataDomain().getEntityResolver();
        EJBQLParser parser = EJBQLParserFactory.getParser();
        EJBQLCompiledExpression select = parser.compile(source, resolver);
        Assert.assertNotNull((Object)select.getExpression());
    }

    @Test
    public void testGetEntityDescriptor() {
        EntityResolver resolver = this.runtime.getDataDomain().getEntityResolver();
        EJBQLParser parser = EJBQLParserFactory.getParser();
        EJBQLCompiledExpression select = parser.compile("select a from Artist a", resolver);
        Assert.assertNotNull((Object)select.getEntityDescriptor("a"));
        Assert.assertSame((Object)resolver.getClassDescriptor("Artist"), (Object)select.getEntityDescriptor("a"));
        EJBQLCompiledExpression select1 = parser.compile("select p from Painting p WHERE p.toArtist.artistName = 'a'", resolver);
        Assert.assertNotNull((Object)select1.getEntityDescriptor("p"));
        Assert.assertSame((Object)resolver.getClassDescriptor("Painting"), (Object)select1.getEntityDescriptor("p"));
        Assert.assertNotNull((Object)select1.getEntityDescriptor("p.toArtist"));
        Assert.assertSame((Object)resolver.getClassDescriptor("Artist"), (Object)select1.getEntityDescriptor("p.toArtist"));
    }

    @Test
    public void testGetRootDescriptor() {
        EntityResolver resolver = this.runtime.getDataDomain().getEntityResolver();
        EJBQLParser parser = EJBQLParserFactory.getParser();
        EJBQLCompiledExpression select = parser.compile("select a from Artist a", resolver);
        Assert.assertSame((String)("Root is not detected: " + select.getExpression()), (Object)resolver.getClassDescriptor("Artist"), (Object)select.getRootDescriptor());
    }

    @Test
    public void testGetEntityDescriptorCaseSensitivity() {
        EntityResolver resolver = this.runtime.getDataDomain().getEntityResolver();
        EJBQLParser parser = EJBQLParserFactory.getParser();
        EJBQLCompiledExpression select1 = parser.compile("select a from Artist a", resolver);
        Assert.assertNotNull((Object)select1.getEntityDescriptor("a"));
        Assert.assertNotNull((Object)select1.getEntityDescriptor("A"));
        EJBQLCompiledExpression select2 = parser.compile("select A from Artist A", resolver);
        Assert.assertNotNull((Object)select2.getEntityDescriptor("a"));
        Assert.assertNotNull((Object)select2.getEntityDescriptor("A"));
        EJBQLCompiledExpression select3 = parser.compile("select a from Artist A", resolver);
        Assert.assertNotNull((Object)select3.getEntityDescriptor("a"));
        Assert.assertNotNull((Object)select3.getEntityDescriptor("A"));
    }
}

