/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sqlserver;

import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.dba.JdbcActionBuilder;
import org.apache.cayenne.dba.sqlserver.SQLServerBatchAction;
import org.apache.cayenne.dba.sqlserver.SQLServerProcedureAction;
import org.apache.cayenne.dba.sqlserver.SQLServerSelectAction;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SelectQuery;

public class SQLServerActionBuilder
extends JdbcActionBuilder {
    public SQLServerActionBuilder(DataNode dataNode) {
        super(dataNode);
    }

    @Override
    public SQLAction batchAction(BatchQuery query) {
        boolean useOptimisticLock = query.isUsingOptimisticLocking();
        boolean runningAsBatch = !useOptimisticLock && this.dataNode.getAdapter().supportsBatchUpdates();
        return new SQLServerBatchAction(query, this.dataNode, runningAsBatch);
    }

    @Override
    public <T> SQLAction objectSelectAction(SelectQuery<T> query) {
        return new SQLServerSelectAction(query, this.dataNode);
    }

    @Override
    public SQLAction procedureAction(ProcedureQuery query) {
        return new SQLServerProcedureAction(query, this.dataNode);
    }
}

