/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.openbase;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.JdbcPkGenerator;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.util.IDUtil;

public class OpenBasePkGenerator
extends JdbcPkGenerator {
    protected OpenBasePkGenerator(JdbcAdapter adapter) {
        super(adapter);
    }

    @Override
    public Object generatePk(DataNode node, DbAttribute pk) throws Exception {
        DbEntity entity = pk.getEntity();
        switch (pk.getType()) {
            case -3: 
            case -2: {
                return IDUtil.pseudoUniqueSecureByteSequence(pk.getMaxLength());
            }
        }
        long value = this.longPkFromDatabase(node, entity);
        if (pk.getType() == -5) {
            return value;
        }
        return (int)value;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected long longPkFromDatabase(DataNode node, DbEntity entity) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String newIDString(DbEntity ent) {
        if (ent.getPrimaryKeys() == null || ent.getPrimaryKeys().size() != 1) {
            throw new CayenneRuntimeException("Error generating pk for DbEntity " + ent.getName() + ": pk must be single attribute", new Object[0]);
        }
        DbAttribute primaryKeyAttribute = ent.getPrimaryKeys().iterator().next();
        return "NEWID FOR " + ent.getName() + ' ' + primaryKeyAttribute.getName();
    }

    public void createAutoPk(DataNode node, List dbEntities) throws Exception {
        for (DbEntity entity : dbEntities) {
            if (!this.canCreatePK(entity)) continue;
            this.runUpdate(node, this.createPKString(entity));
            this.runUpdate(node, this.createUniquePKIndexString(entity));
        }
    }

    public List createAutoPkStatements(List dbEntities) {
        ArrayList<String> list = new ArrayList<String>(2 * dbEntities.size());
        for (DbEntity entity : dbEntities) {
            if (!this.canCreatePK(entity)) continue;
            list.add(this.createPKString(entity));
            list.add(this.createUniquePKIndexString(entity));
        }
        return list;
    }

    protected boolean canCreatePK(DbEntity entity) {
        return entity.getPrimaryKeys().size() > 0;
    }

    public void dropAutoPk(DataNode node, List dbEntities) throws Exception {
    }

    public List dropAutoPkStatements(List dbEntities) {
        return Collections.EMPTY_LIST;
    }

    protected String createPKString(DbEntity entity) {
        Collection<DbAttribute> pk = entity.getPrimaryKeys();
        if (pk == null || pk.size() == 0) {
            throw new CayenneRuntimeException("Entity '" + entity.getName() + "' has no PK defined.", new Object[0]);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("CREATE PRIMARY KEY ");
        QuotingStrategy context = this.getAdapter().getQuotingStrategy();
        buffer.append(context.quotedIdentifier(entity, entity.getName()));
        buffer.append(" (");
        Iterator<DbAttribute> it = pk.iterator();
        DbAttribute firstColumn = it.next();
        buffer.append(context.quotedName(firstColumn));
        while (it.hasNext()) {
            DbAttribute column = it.next();
            buffer.append(", ");
            buffer.append(context.quotedName(column));
        }
        buffer.append(")");
        return buffer.toString();
    }

    protected String createUniquePKIndexString(DbEntity entity) {
        Collection<DbAttribute> pk = entity.getPrimaryKeys();
        QuotingStrategy context = this.getAdapter().getQuotingStrategy();
        if (pk == null || pk.size() == 0) {
            throw new CayenneRuntimeException("Entity '" + entity.getName() + "' has no PK defined.", new Object[0]);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(pk.size() == 1 ? "CREATE UNIQUE INDEX " : "CREATE INDEX ");
        buffer.append(context.quotedIdentifier(entity, entity.getName()));
        buffer.append(" (");
        Iterator<DbAttribute> it = pk.iterator();
        DbAttribute firstColumn = it.next();
        buffer.append(context.quotedName(firstColumn));
        while (it.hasNext()) {
            DbAttribute column = it.next();
            buffer.append(", ");
            buffer.append(context.quotedName(column));
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public void reset() {
    }

    @Override
    public int getPkCacheSize() {
        return 0;
    }

    @Override
    public void setPkCacheSize(int pkCacheSize) {
    }
}

