/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.mysql;

import org.apache.cayenne.dba.mysql.MySQLAdapter;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class MySQLAdapterIT
extends ServerCase {
    @Inject
    private AdhocObjectFactory objectFactory;

    @Test
    public void testCreateTableAppendPKClause() {
        MySQLAdapter adapter = (MySQLAdapter)this.objectFactory.newInstance(MySQLAdapter.class, MySQLAdapter.class.getName());
        DbEntity e = new DbEntity("Test");
        DbAttribute pk1 = new DbAttribute("PK1");
        pk1.setPrimaryKey(true);
        e.addAttribute(pk1);
        DbAttribute pk2 = new DbAttribute("PK2");
        pk2.setPrimaryKey(true);
        e.addAttribute(pk2);
        StringBuffer b1 = new StringBuffer();
        adapter.createTableAppendPKClause(b1, e);
        Assert.assertTrue((b1.indexOf("PK1") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((b1.indexOf("PK2") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((b1.indexOf("PK1") < b1.indexOf("PK2") ? 1 : 0) != 0);
        pk2.setGenerated(true);
        StringBuffer b2 = new StringBuffer();
        adapter.createTableAppendPKClause(b2, e);
        Assert.assertTrue((b2.indexOf("PK1") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((b2.indexOf("PK2") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((b2.indexOf("PK1") > b2.indexOf("PK2") ? 1 : 0) != 0);
    }
}

