/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.h2;

import java.util.List;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.h2.H2MergerFactory;
import org.apache.cayenne.dba.h2.H2PkGenerator;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.resource.ResourceLocator;

public class H2Adapter
extends JdbcAdapter {
    public H2Adapter(@Inject RuntimeProperties runtimeProperties, @Inject(value="cayenne.server.default_types") List<ExtendedType> defaultExtendedTypes, @Inject(value="cayenne.server.user_types") List<ExtendedType> userExtendedTypes, @Inject(value="cayenne.server.type_factories") List<ExtendedTypeFactory> extendedTypeFactories, @Inject ResourceLocator resourceLocator) {
        super(runtimeProperties, defaultExtendedTypes, userExtendedTypes, extendedTypeFactories, resourceLocator);
        this.setSupportsGeneratedKeys(true);
    }

    @Override
    public MergerFactory mergerFactory() {
        return new H2MergerFactory();
    }

    @Override
    public void createTableAppendColumn(StringBuffer sqlBuffer, DbAttribute column) {
        super.createTableAppendColumn(sqlBuffer, column);
        if (column.isGenerated()) {
            sqlBuffer.append(" AUTO_INCREMENT");
        }
    }

    @Override
    protected PkGenerator createPkGenerator() {
        return new H2PkGenerator(this);
    }
}

