/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import org.apache.cayenne.dba.DefaultQuotingStrategy;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.junit.Assert;
import org.junit.Test;

public class DefaultQuotingStrategyTest {
    @Test
    public void testQuotedIdentifer() {
        DataMap dm = new DataMap();
        dm.setQuotingSQLIdentifiers(true);
        DbEntity de = new DbEntity();
        de.setDataMap(dm);
        DefaultQuotingStrategy strategy = new DefaultQuotingStrategy("[", "]");
        Assert.assertEquals((Object)"[a]", (Object)strategy.quotedIdentifier(de, "a"));
        Assert.assertEquals((Object)"[a]", (Object)strategy.quotedIdentifier(de, null, null, "a"));
        Assert.assertEquals((Object)"[c].[b].[a]", (Object)strategy.quotedIdentifier(de, "c", "b", "a"));
    }

    @Test
    public void testUnQuotedIdentifer() {
        DataMap dm = new DataMap();
        dm.setQuotingSQLIdentifiers(false);
        DbEntity de = new DbEntity();
        de.setDataMap(dm);
        DefaultQuotingStrategy strategy = new DefaultQuotingStrategy("[", "]");
        Assert.assertEquals((Object)"a", (Object)strategy.quotedIdentifier(de, "a"));
        Assert.assertEquals((Object)"a", (Object)strategy.quotedIdentifier(de, null, null, "a"));
        Assert.assertEquals((Object)"c.b.a", (Object)strategy.quotedIdentifier(de, "c", "b", "a"));
    }
}

