/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conn;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.cayenne.conn.PooledConnectionImpl;

public class ConnectionWrapper
implements Connection {
    private Connection connection;
    private PooledConnectionImpl pooledConnection;
    private long lastReconnected;
    private int reconnectCount;

    static void sybaseAutoCommitPatch(Connection c, SQLException e, boolean autoCommit) throws SQLException {
        String s = e.getMessage().toLowerCase();
        if (!s.contains("set chained command not allowed")) {
            throw e;
        }
        c.commit();
        c.setAutoCommit(autoCommit);
    }

    public ConnectionWrapper(Connection connection, PooledConnectionImpl pooledConnection) {
        this.connection = connection;
        this.pooledConnection = pooledConnection;
    }

    protected void reconnect(SQLException exception) throws SQLException {
        if (this.reconnectCount > 0 && System.currentTimeMillis() - this.lastReconnected < 60000L) {
            this.retire(exception);
            throw exception;
        }
        this.pooledConnection.reconnect();
        Connection connection = this.pooledConnection.getConnection();
        this.connection = connection instanceof ConnectionWrapper ? ((ConnectionWrapper)connection).connection : connection;
        this.lastReconnected = System.currentTimeMillis();
        ++this.reconnectCount;
    }

    protected void retire(SQLException exception) {
        this.pooledConnection.connectionErrorNotification(exception);
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.connection.clearWarnings();
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    @Override
    public void close() throws SQLException {
        if (null != this.pooledConnection) {
            this.pooledConnection.returnConnectionToThePool();
        }
        this.connection = null;
        this.pooledConnection = null;
    }

    @Override
    public void commit() throws SQLException {
        try {
            this.connection.commit();
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            return this.connection.createStatement();
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.createStatement();
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.connection.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.createStatement(resultSetType, resultSetConcurrency);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            return this.connection.getAutoCommit();
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            return this.connection.getCatalog();
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.connection.getMetaData();
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            return this.connection.getTransactionIsolation();
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.connection.getWarnings();
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.connection != null) {
            try {
                return this.connection.isClosed();
            }
            catch (SQLException sqlEx) {
                this.retire(sqlEx);
                throw sqlEx;
            }
        }
        return true;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            return this.connection.isReadOnly();
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        try {
            return this.connection.nativeSQL(sql);
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            return this.connection.prepareCall(sql);
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.prepareCall(sql);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            return this.connection.prepareStatement(sql);
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.prepareStatement(sql);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            this.connection.rollback();
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            this.connection.setAutoCommit(autoCommit);
        }
        catch (SQLException sqlEx) {
            try {
                ConnectionWrapper.sybaseAutoCommitPatch(this.connection, sqlEx, autoCommit);
            }
            catch (SQLException patchEx) {
                this.retire(sqlEx);
                throw sqlEx;
            }
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        try {
            this.connection.setCatalog(catalog);
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this.connection.setReadOnly(readOnly);
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        try {
            this.connection.setTransactionIsolation(level);
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            return this.connection.getTypeMap();
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        try {
            this.connection.setTypeMap(map);
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new UnsupportedOperationException("Method setHoldability() not yet implemented.");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException("Method getHoldability() not yet implemented.");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException("Method setSavepoint() not yet implemented.");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new UnsupportedOperationException("Method setSavepoint() not yet implemented.");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException("Method rollback() not yet implemented.");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException("Method releaseSavepoint() not yet implemented.");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException("Method createStatement() not yet implemented.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException("Method prepareStatement() not yet implemented.");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.connection.prepareStatement(sql, autoGeneratedKeys);
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.prepareStatement(sql, autoGeneratedKeys);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.connection.prepareStatement(sql, columnIndexes);
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.prepareStatement(sql, columnIndexes);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            return this.connection.prepareStatement(sql, columnNames);
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.prepareStatement(sql, columnNames);
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        try {
            return this.connection.createArrayOf(typeName, elements);
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.createArrayOf(typeName, elements);
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        try {
            return this.connection.createBlob();
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.createBlob();
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        try {
            return this.connection.createClob();
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.createClob();
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        try {
            return this.connection.createStruct(typeName, attributes);
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.createStruct(typeName, attributes);
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            return this.connection.getClientInfo();
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.getClientInfo();
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        try {
            return this.connection.getClientInfo(name);
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.getClientInfo(name);
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        try {
            return this.connection.isValid(timeout);
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.isValid(timeout);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        try {
            return this.connection.createNClob();
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.createNClob();
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            return this.connection.createSQLXML();
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.createSQLXML();
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSchema() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new UnsupportedOperationException();
    }
}

