/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.util.List;
import javax.sql.DataSource;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.configuration.server.ServerRuntimeBuilder;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.query.SQLSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ServerRuntimeBuilderIT
extends ServerCase {
    @Inject
    private DBHelper dbHelper;
    @Inject
    private ServerRuntime runtime;
    @Inject
    private DataSourceInfo dsi;
    private ServerRuntime localRuntime;
    private DataSource dataSource;

    @After
    public void stopLocalRuntime() {
        if (this.localRuntime != null) {
            this.localRuntime.shutdown();
        }
    }

    @Before
    public void setUp() throws Exception {
        TableHelper tArtist = new TableHelper(this.dbHelper, "ARTIST");
        tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        tArtist.insert(new Object[]{33001, "AA1"});
        tArtist.insert(new Object[]{33002, "AA2"});
        this.dataSource = this.runtime.getDataSource("testmap");
    }

    @Test
    public void testConfigFree_WithDataSource() {
        this.localRuntime = new ServerRuntimeBuilder().dataSource(this.dataSource).build();
        List<DataRow> result = SQLSelect.dataRowQuery("SELECT * FROM ARTIST").select(this.localRuntime.newContext());
        Assert.assertEquals((long)2L, (long)result.size());
    }

    @Test
    public void testConfigFree_WithDBParams() {
        this.localRuntime = new ServerRuntimeBuilder().jdbcDriver(this.dsi.getJdbcDriver()).url(this.dsi.getDataSourceUrl()).password(this.dsi.getPassword()).user(this.dsi.getUserName()).minConnections(1).maxConnections(2).build();
        List<DataRow> result = SQLSelect.dataRowQuery("SELECT * FROM ARTIST").select(this.localRuntime.newContext());
        Assert.assertEquals((long)2L, (long)result.size());
    }

    @Test
    public void testNoNodeConfig_WithDataSource() {
        this.localRuntime = new ServerRuntimeBuilder().addConfig("cayenne-testmap.xml").dataSource(this.dataSource).build();
        DataMap map = this.localRuntime.getDataDomain().getDataMap("testmap");
        Assert.assertNotNull((Object)map);
        DataNode node = this.localRuntime.getDataDomain().getDefaultNode();
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((long)1L, (long)node.getDataMaps().size());
        Assert.assertSame((Object)map, (Object)node.getDataMap("testmap"));
    }

    @Test
    public void testNoNodeConfig_WithDBParams() {
        this.localRuntime = new ServerRuntimeBuilder().addConfig("cayenne-testmap.xml").jdbcDriver(this.dsi.getJdbcDriver()).url(this.dsi.getDataSourceUrl()).password(this.dsi.getPassword()).user(this.dsi.getUserName()).minConnections(1).maxConnections(2).build();
        DataMap map = this.localRuntime.getDataDomain().getDataMap("testmap");
        Assert.assertNotNull((Object)map);
        DataNode node = this.localRuntime.getDataDomain().getDefaultNode();
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((long)1L, (long)node.getDataMaps().size());
        Assert.assertSame((Object)map, (Object)node.getDataMap("testmap"));
    }

    @Test
    public void test_UnnamedDomain_MultiLocation() {
        this.localRuntime = new ServerRuntimeBuilder().addConfigs("cayenne-testmap.xml", "cayenne-embeddable.xml").build();
        Assert.assertEquals((Object)"cayenne", (Object)this.localRuntime.getDataDomain().getName());
    }

    @Test
    public void test_NamedDomain_MultiLocation() {
        this.localRuntime = new ServerRuntimeBuilder("myd").addConfigs("cayenne-testmap.xml", "cayenne-embeddable.xml").build();
        Assert.assertEquals((Object)"myd", (Object)this.localRuntime.getDataDomain().getName());
    }
}

