/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.configuration.mock.MockDataSourceFactory1;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.configuration.server.DelegatingDataSourceFactory;
import org.apache.cayenne.configuration.server.PropertyDataSourceFactory;
import org.apache.cayenne.configuration.server.XMLPoolingDataSourceFactory;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.ClassLoaderManager;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.di.spi.DefaultAdhocObjectFactory;
import org.apache.cayenne.di.spi.DefaultClassLoaderManager;
import org.apache.cayenne.log.CommonsJdbcEventLogger;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.resource.ResourceLocator;
import org.apache.cayenne.resource.mock.MockResourceLocator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class DefaultDataSourceFactoryLoaderTest {
    private Injector injector;

    @Before
    public void setUp() throws Exception {
        Module testModule = new Module(){

            public void configure(Binder binder) {
                binder.bind(ClassLoaderManager.class).to(DefaultClassLoaderManager.class);
                binder.bind(AdhocObjectFactory.class).to(DefaultAdhocObjectFactory.class);
                binder.bind(ResourceLocator.class).to(MockResourceLocator.class);
                binder.bind(RuntimeProperties.class).toInstance(Mockito.mock(RuntimeProperties.class));
                binder.bind(JdbcEventLogger.class).to(CommonsJdbcEventLogger.class);
            }
        };
        this.injector = DIBootstrap.createInjector((Module[])new Module[]{testModule});
    }

    @Test
    public void testGetDataSourceFactory_Implicit() throws Exception {
        DataNodeDescriptor nodeDescriptor = new DataNodeDescriptor();
        nodeDescriptor.setName("node1");
        nodeDescriptor.setDataSourceDescriptor(new DataSourceInfo());
        DelegatingDataSourceFactory factoryLoader = new DelegatingDataSourceFactory();
        this.injector.injectMembers((Object)factoryLoader);
        DataSourceFactory factory = factoryLoader.getDataSourceFactory(nodeDescriptor);
        Assert.assertNotNull((Object)factory);
        Assert.assertTrue((boolean)(factory instanceof XMLPoolingDataSourceFactory));
    }

    @Test
    public void testGetDataSourceFactory_Explicit() throws Exception {
        DataNodeDescriptor nodeDescriptor = new DataNodeDescriptor();
        nodeDescriptor.setName("node1");
        nodeDescriptor.setDataSourceFactoryType(MockDataSourceFactory1.class.getName());
        DelegatingDataSourceFactory factoryLoader = new DelegatingDataSourceFactory();
        this.injector.injectMembers((Object)factoryLoader);
        DataSourceFactory factory = factoryLoader.getDataSourceFactory(nodeDescriptor);
        Assert.assertNotNull((Object)factory);
        Assert.assertTrue((boolean)(factory instanceof MockDataSourceFactory1));
        Assert.assertSame((String)"Injection on the factory hasn't been performed", (Object)this.injector, (Object)((MockDataSourceFactory1)factory).getInjector());
    }

    @Test
    public void testGetDataSourceFactory_Property() throws Exception {
        final RuntimeProperties properties = (RuntimeProperties)Mockito.mock(RuntimeProperties.class);
        Mockito.when((Object)properties.get("cayenne.jdbc.driver")).thenReturn((Object)"x");
        Mockito.when((Object)properties.get("cayenne.jdbc.url")).thenReturn((Object)"y");
        DataChannelDescriptor channelDescriptor = new DataChannelDescriptor();
        channelDescriptor.setName("X");
        DataNodeDescriptor nodeDescriptor = new DataNodeDescriptor();
        nodeDescriptor.setName("node1");
        nodeDescriptor.setDataSourceFactoryType(MockDataSourceFactory1.class.getName());
        nodeDescriptor.setDataChannelDescriptor(channelDescriptor);
        Module testModule = new Module(){

            public void configure(Binder binder) {
                binder.bind(ClassLoaderManager.class).to(DefaultClassLoaderManager.class);
                binder.bind(AdhocObjectFactory.class).to(DefaultAdhocObjectFactory.class);
                binder.bind(ResourceLocator.class).to(MockResourceLocator.class);
                binder.bind(RuntimeProperties.class).toInstance((Object)properties);
                binder.bind(JdbcEventLogger.class).to(CommonsJdbcEventLogger.class);
            }
        };
        Injector injector = DIBootstrap.createInjector((Module[])new Module[]{testModule});
        DelegatingDataSourceFactory factoryLoader = new DelegatingDataSourceFactory();
        injector.injectMembers((Object)factoryLoader);
        DataSourceFactory factory = factoryLoader.getDataSourceFactory(nodeDescriptor);
        Assert.assertNotNull((Object)factory);
        Assert.assertTrue((boolean)(factory instanceof PropertyDataSourceFactory));
        Mockito.when((Object)properties.get("cayenne.jdbc.url")).thenReturn(null);
        factory = factoryLoader.getDataSourceFactory(nodeDescriptor);
        Assert.assertNotNull((Object)factory);
        Assert.assertFalse((boolean)(factory instanceof PropertyDataSourceFactory));
        Mockito.when((Object)properties.get("cayenne.jdbc.url.X.node2")).thenReturn((Object)"y");
        factory = factoryLoader.getDataSourceFactory(nodeDescriptor);
        Assert.assertNotNull((Object)factory);
        Assert.assertFalse((boolean)(factory instanceof PropertyDataSourceFactory));
        Mockito.when((Object)properties.get("cayenne.jdbc.url.X.node1")).thenReturn((Object)"y");
        factory = factoryLoader.getDataSourceFactory(nodeDescriptor);
        Assert.assertNotNull((Object)factory);
        Assert.assertTrue((boolean)(factory instanceof PropertyDataSourceFactory));
    }
}

