/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.util.Collections;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DefaultObjectMapRetainStrategy;
import org.apache.cayenne.access.ObjectMapRetainStrategy;
import org.apache.cayenne.cache.MapQueryCache;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.configuration.DefaultObjectStoreFactory;
import org.apache.cayenne.configuration.DefaultRuntimeProperties;
import org.apache.cayenne.configuration.ObjectStoreFactory;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.configuration.server.DataContextFactory;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.event.MockEventManager;
import org.apache.cayenne.log.CommonsJdbcEventLogger;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.tx.DefaultTransactionFactory;
import org.apache.cayenne.tx.DefaultTransactionManager;
import org.apache.cayenne.tx.TransactionFactory;
import org.apache.cayenne.tx.TransactionManager;
import org.junit.Assert;
import org.junit.Test;

public class DataContextFactoryTest {
    @Test
    public void testCreateDataContextWithDedicatedCache() throws Exception {
        final MockEventManager eventManager = new MockEventManager();
        final DataDomain domain = new DataDomain("d1");
        domain.setSharedCacheEnabled(false);
        Module testModule = new Module(){

            public void configure(Binder binder) {
                binder.bind(JdbcEventLogger.class).to(CommonsJdbcEventLogger.class);
                binder.bind(DataDomain.class).toInstance((Object)domain);
                binder.bind(EventManager.class).toInstance((Object)eventManager);
                binder.bind(QueryCache.class).toInstance((Object)new MapQueryCache(5));
                binder.bind(RuntimeProperties.class).toInstance((Object)new DefaultRuntimeProperties(Collections.EMPTY_MAP));
                binder.bind(ObjectMapRetainStrategy.class).to(DefaultObjectMapRetainStrategy.class);
                binder.bind(ObjectStoreFactory.class).to(DefaultObjectStoreFactory.class);
                binder.bind(TransactionFactory.class).to(DefaultTransactionFactory.class);
                binder.bind(TransactionManager.class).to(DefaultTransactionManager.class);
            }
        };
        Injector injector = DIBootstrap.createInjector((Module[])new Module[]{testModule});
        DataContextFactory factory = new DataContextFactory();
        injector.injectMembers((Object)factory);
        DataContext c3 = (DataContext)factory.createContext();
        Assert.assertNotNull((Object)c3.getObjectStore().getDataRowCache());
        Assert.assertNull((Object)domain.getSharedSnapshotCache());
        Assert.assertNotSame((Object)c3.getObjectStore().getDataRowCache(), (Object)domain.getSharedSnapshotCache());
    }

    @Test
    public void testCreateDataContextValidation() throws Exception {
        final MockEventManager eventManager = new MockEventManager();
        final DataDomain domain = new DataDomain("d1");
        domain.setValidatingObjectsOnCommit(true);
        Module testModule = new Module(){

            public void configure(Binder binder) {
                binder.bind(JdbcEventLogger.class).to(CommonsJdbcEventLogger.class);
                binder.bind(DataDomain.class).toInstance((Object)domain);
                binder.bind(EventManager.class).toInstance((Object)eventManager);
                binder.bind(QueryCache.class).toInstance((Object)new MapQueryCache(5));
                binder.bind(RuntimeProperties.class).toInstance((Object)new DefaultRuntimeProperties(Collections.EMPTY_MAP));
                binder.bind(ObjectMapRetainStrategy.class).to(DefaultObjectMapRetainStrategy.class);
                binder.bind(ObjectStoreFactory.class).to(DefaultObjectStoreFactory.class);
                binder.bind(TransactionFactory.class).to(DefaultTransactionFactory.class);
                binder.bind(TransactionManager.class).to(DefaultTransactionManager.class);
            }
        };
        Injector injector = DIBootstrap.createInjector((Module[])new Module[]{testModule});
        DataContextFactory factory = new DataContextFactory();
        injector.injectMembers((Object)factory);
        DataContext c1 = (DataContext)factory.createContext();
        Assert.assertTrue((boolean)c1.isValidatingObjectsOnCommit());
        domain.setValidatingObjectsOnCommit(false);
        DataContext c2 = (DataContext)factory.createContext();
        Assert.assertFalse((boolean)c2.isValidatingObjectsOnCommit());
    }
}

