/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import org.apache.cayenne.DataChannel;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.cache.NestedQueryCache;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.configuration.ObjectContextFactory;
import org.apache.cayenne.configuration.ObjectStoreFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.tx.TransactionFactory;

public class DataContextFactory
implements ObjectContextFactory {
    @Inject
    protected DataDomain dataDomain;
    @Inject
    protected EventManager eventManager;
    @Inject
    protected Injector injector;
    @Inject
    protected ObjectStoreFactory objectStoreFactory;
    @Inject
    protected QueryCache queryCache;
    @Inject
    protected TransactionFactory transactionFactory;

    @Override
    public ObjectContext createContext() {
        return this.createdFromDataDomain(this.dataDomain);
    }

    @Override
    public ObjectContext createContext(DataChannel parent) {
        if (parent instanceof DataDomain) {
            return this.createdFromDataDomain((DataDomain)parent);
        }
        if (parent instanceof DataContext) {
            return this.createFromDataContext((DataContext)parent);
        }
        return this.createFromGenericChannel(parent);
    }

    protected ObjectContext createFromGenericChannel(DataChannel parent) {
        DataRowStore snapshotCache = this.dataDomain.isSharedCacheEnabled() ? this.dataDomain.getSharedSnapshotCache() : new DataRowStore(this.dataDomain.getName(), this.dataDomain.getProperties(), this.eventManager);
        DataContext context = this.newInstance(parent, this.objectStoreFactory.createObjectStore(snapshotCache));
        context.setValidatingObjectsOnCommit(this.dataDomain.isValidatingObjectsOnCommit());
        context.setQueryCache(new NestedQueryCache(this.queryCache));
        return context;
    }

    protected ObjectContext createFromDataContext(DataContext parent) {
        ObjectStore objectStore = this.objectStoreFactory.createObjectStore(null);
        DataContext context = this.newInstance(parent, objectStore);
        context.setValidatingObjectsOnCommit(parent.isValidatingObjectsOnCommit());
        context.setUsingSharedSnapshotCache(parent.isUsingSharedSnapshotCache());
        context.setQueryCache(new NestedQueryCache(this.queryCache));
        return context;
    }

    protected ObjectContext createdFromDataDomain(DataDomain parent) {
        DataRowStore snapshotCache = parent.isSharedCacheEnabled() ? parent.getSharedSnapshotCache() : new DataRowStore(parent.getName(), parent.getProperties(), this.eventManager);
        DataContext context = this.newInstance(parent, this.objectStoreFactory.createObjectStore(snapshotCache));
        context.setValidatingObjectsOnCommit(parent.isValidatingObjectsOnCommit());
        context.setQueryCache(new NestedQueryCache(this.queryCache));
        context.setTransactionFactory(this.transactionFactory);
        return context;
    }

    protected DataContext newInstance(DataChannel parent, ObjectStore objectStore) {
        return new DataContext(parent, objectStore);
    }
}

