/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.resource.ResourceLocator;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBCPDataSourceFactory
implements DataSourceFactory {
    private static final String DBCP_PROPERTIES = "dbcp.properties";
    private static final Log logger = LogFactory.getLog(DBCPDataSourceFactory.class);
    @Inject
    protected ResourceLocator resourceLocator;

    @Override
    public DataSource getDataSource(DataNodeDescriptor nodeDescriptor) throws Exception {
        Resource baseConfiguration;
        String location = nodeDescriptor.getParameters();
        if (location == null) {
            logger.debug((Object)"No explicit DBCP config location, will use default location: dbcp.properties");
            location = DBCP_PROPERTIES;
        }
        if ((baseConfiguration = nodeDescriptor.getConfigurationSource()) == null) {
            throw new CayenneRuntimeException("Null 'configurationSource' for nodeDescriptor '%s'", nodeDescriptor.getName());
        }
        Resource dbcpConfiguration = baseConfiguration.getRelativeResource(location);
        if (dbcpConfiguration == null) {
            throw new CayenneRuntimeException("Missing DBCP configuration '%s' for nodeDescriptor '%s'", location, nodeDescriptor.getName());
        }
        Properties properties = this.getProperties(dbcpConfiguration);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DBCP Properties: " + properties));
        }
        properties = this.filteredDeprecatedProperties(properties);
        return BasicDataSourceFactory.createDataSource((Properties)properties);
    }

    private Properties filteredDeprecatedProperties(Properties unfiltered) {
        Properties properties = new Properties();
        String deprecatedPrefix = "cayenne.dbcp.";
        for (Map.Entry<Object, Object> entry : unfiltered.entrySet()) {
            Object key = entry.getKey();
            if (key instanceof String && key.toString().startsWith("cayenne.dbcp.")) {
                String oldKey = key.toString();
                key = oldKey.substring("cayenne.dbcp.".length());
                logger.info((Object)("Deprecated use of 'cayenne.dbcp.' prefix in '" + oldKey + "', converting to " + key));
            }
            properties.put(key, entry.getValue());
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProperties(Resource dbcpConfiguration) throws IOException {
        Properties properties = new Properties();
        InputStream in = dbcpConfiguration.getURL().openStream();
        try {
            properties.load(in);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
        return properties;
    }
}

