/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration;

import java.util.HashMap;
import org.apache.cayenne.configuration.DefaultRuntimeProperties;
import org.junit.Assert;
import org.junit.Test;

public class DefaultRuntimePropertiesTest {
    @Test
    public void testGet_FromMap() {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        propertiesMap.put("key1", "v1");
        DefaultRuntimeProperties properties = new DefaultRuntimeProperties(propertiesMap);
        Assert.assertEquals((Object)"v1", (Object)properties.get("key1"));
        Assert.assertNull((Object)properties.get("key2"));
    }

    @Test
    public void testGet_FromSystem() {
        String userDir = System.getProperty("user.dir");
        Assert.assertNotNull((Object)userDir);
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        DefaultRuntimeProperties properties = new DefaultRuntimeProperties(propertiesMap);
        Assert.assertEquals((Object)userDir, (Object)properties.get("user.dir"));
    }

    @Test
    public void testGet_FromSystemOverridesMap() {
        String userDir = System.getProperty("user.dir");
        Assert.assertNotNull((Object)userDir);
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        propertiesMap.put("user.dir", userDir + "_altered");
        DefaultRuntimeProperties properties = new DefaultRuntimeProperties(propertiesMap);
        Assert.assertEquals((Object)userDir, (Object)properties.get("user.dir"));
    }
}

