/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import org.apache.cayenne.access.types.EnumType;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.access.types.InnerEnumHolder;
import org.apache.cayenne.access.types.MockEnum;
import org.apache.cayenne.access.types.MockEnum2;
import org.junit.Assert;
import org.junit.Test;

public class ExtendedTypeMapEnumsTest {
    @Test
    public void testCreateType1_5() {
        ExtendedTypeMap map = new ExtendedTypeMap();
        Assert.assertNull((Object)map.createType(Object.class.getName()));
        ExtendedType type = map.createType(MockEnum.class.getName());
        Assert.assertTrue((boolean)(type instanceof EnumType));
        Assert.assertEquals(MockEnum.class, ((EnumType)type).enumClass);
        ExtendedType type2 = map.createType(MockEnum2.class.getName());
        Assert.assertNotSame((Object)type, (Object)type2);
    }

    @Test
    public void testCreateType1_5InnerEnum() {
        ExtendedTypeMap map = new ExtendedTypeMap();
        ExtendedType type = map.createType(InnerEnumHolder.InnerEnum.class.getName());
        Assert.assertTrue((boolean)(type instanceof EnumType));
        Assert.assertEquals(InnerEnumHolder.InnerEnum.class, ((EnumType)type).enumClass);
        ExtendedType type1 = map.createType(InnerEnumHolder.class.getName() + "$InnerEnum");
        Assert.assertNotNull((Object)type1);
        Assert.assertSame((Object)type.getClassName(), (Object)type1.getClassName());
        ExtendedType type2 = map.createType(InnerEnumHolder.class.getName() + ".InnerEnum");
        Assert.assertNotNull((Object)type2);
        Assert.assertSame((Object)type.getClassName(), (Object)type2.getClassName());
    }

    @Test
    public void testGetDefaultType1_4() {
        ExtendedTypeMap map = new ExtendedTypeMap();
        map.internalTypeFactories.clear();
        Assert.assertNull((Object)map.createType(Object.class.getName()));
        Assert.assertNull((Object)map.createType(MockEnum.class.getName()));
        Assert.assertNull((Object)map.createType(MockEnum2.class.getName()));
    }

    @Test
    public void testGetType() {
        ExtendedTypeMap map = new ExtendedTypeMap();
        ExtendedType type = map.getRegisteredType(MockEnum.class.getName());
        Assert.assertNotNull((Object)type);
        Assert.assertTrue((boolean)(type instanceof EnumType));
    }
}

