/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.cayenne.access.types.ByteOrCharArrayFactory;
import org.apache.cayenne.access.types.EnumTypeFactory;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ObjectType;
import org.apache.cayenne.access.types.SerializableTypeFactory;
import org.apache.cayenne.access.types.SubclassTypeFactory;
import org.apache.cayenne.util.Util;

public class ExtendedTypeMap {
    static final Map<String, String> classesForPrimitives = new HashMap<String, String>();
    protected final Map<String, ExtendedType> typeMap;
    protected ExtendedType defaultType = new ObjectType();
    Collection<ExtendedTypeFactory> extendedTypeFactories;
    Collection<ExtendedTypeFactory> internalTypeFactories;

    public ExtendedTypeMap() {
        this.typeMap = new ConcurrentHashMap<String, ExtendedType>();
        this.extendedTypeFactories = new CopyOnWriteArrayList<ExtendedTypeFactory>();
        this.internalTypeFactories = new CopyOnWriteArrayList<ExtendedTypeFactory>();
        this.initDefaultFactories();
    }

    protected void initDefaultFactories() {
        this.internalTypeFactories.add(new EnumTypeFactory());
        this.internalTypeFactories.add(new ByteOrCharArrayFactory(this));
        this.internalTypeFactories.add(new SerializableTypeFactory(this));
    }

    public void addFactory(ExtendedTypeFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Attempt to add null factory");
        }
        this.extendedTypeFactories.add(factory);
    }

    public void removeFactory(ExtendedTypeFactory factory) {
        if (factory != null) {
            this.extendedTypeFactories.remove(factory);
        }
    }

    public void registerType(ExtendedType type) {
        this.typeMap.put(type.getClassName(), type);
        this.addFactory(new SubclassTypeFactory(type));
    }

    public ExtendedType getDefaultType() {
        return this.defaultType;
    }

    public ExtendedType getRegisteredType(String javaClassName) {
        ExtendedType type;
        if (javaClassName == null) {
            return this.getDefaultType();
        }
        String nonPrimitive = classesForPrimitives.get(javaClassName);
        if (nonPrimitive != null) {
            javaClassName = nonPrimitive;
        }
        if ((type = this.getExplictlyRegisteredType(javaClassName)) != null) {
            return type;
        }
        type = this.createType(javaClassName);
        if (type != null) {
            this.registerType(type);
            return type;
        }
        return this.getDefaultType();
    }

    ExtendedType getExplictlyRegisteredType(String className) {
        if (className == null) {
            throw new NullPointerException("Null className");
        }
        return this.typeMap.get(className);
    }

    public ExtendedType getRegisteredType(Class<?> javaClass) {
        String name = null;
        name = javaClass.isArray() ? javaClass.getComponentType().getName() + "[]" : javaClass.getName();
        return this.getRegisteredType(name);
    }

    public void unregisterType(String javaClassName) {
        this.typeMap.remove(javaClassName);
    }

    public String[] getRegisteredTypeNames() {
        Set<String> keys = this.typeMap.keySet();
        int len = keys.size();
        String[] types = new String[len];
        Iterator<String> it = keys.iterator();
        for (int i = 0; i < len; ++i) {
            types[i] = it.next();
        }
        return types;
    }

    protected ExtendedType createType(String className) {
        ExtendedType type;
        Class<?> typeClass;
        if (className == null) {
            return null;
        }
        try {
            typeClass = Util.getJavaClass(className);
        }
        catch (Throwable th) {
            return null;
        }
        for (ExtendedTypeFactory factory : this.extendedTypeFactories) {
            type = factory.getType(typeClass);
            if (type == null) continue;
            return type;
        }
        for (ExtendedTypeFactory factory : this.internalTypeFactories) {
            type = factory.getType(typeClass);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    static {
        classesForPrimitives.put("long", Long.class.getName());
        classesForPrimitives.put("double", Double.class.getName());
        classesForPrimitives.put("byte", Byte.class.getName());
        classesForPrimitives.put("boolean", Boolean.class.getName());
        classesForPrimitives.put("float", Float.class.getName());
        classesForPrimitives.put("short", Short.class.getName());
        classesForPrimitives.put("int", Integer.class.getName());
    }
}

