/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import org.apache.cayenne.access.types.ByteArrayType;
import org.junit.Assert;
import org.junit.Test;

public class ByteArrayTypeTest {
    @Test
    public void testTrimBytes1() throws Exception {
        byte[] b1 = new byte[]{1, 2, 3};
        byte[] b2 = ByteArrayType.trimBytes(b1);
        ByteArrayTypeTest.assertByteArraysEqual(b1, b2);
    }

    @Test
    public void testTrimBytes2() throws Exception {
        byte[] ref = new byte[]{1, 2, 3};
        byte[] b1 = new byte[]{1, 2, 3, 0, 0};
        byte[] b2 = ByteArrayType.trimBytes(b1);
        ByteArrayTypeTest.assertByteArraysEqual(ref, b2);
    }

    @Test
    public void testTrimBytes3() throws Exception {
        byte[] b1 = new byte[]{0, 1, 2, 3};
        byte[] b2 = ByteArrayType.trimBytes(b1);
        ByteArrayTypeTest.assertByteArraysEqual(b1, b2);
    }

    @Test
    public void testTrimBytes4() throws Exception {
        byte[] b1 = new byte[]{};
        byte[] b2 = ByteArrayType.trimBytes(b1);
        ByteArrayTypeTest.assertByteArraysEqual(b1, b2);
    }

    public static void assertByteArraysEqual(byte[] b1, byte[] b2) throws Exception {
        if (b1 == b2) {
            return;
        }
        if (b1 == null && b2 == null) {
            return;
        }
        if (b1 == null) {
            Assert.fail((String)"byte arrays differ (first one is null)");
        }
        if (b2 == null) {
            Assert.fail((String)"byte arrays differ (second one is null)");
        }
        if (b1.length != b2.length) {
            Assert.fail((String)("byte arrays differ (length differs: [" + b1.length + "," + b2.length + "])"));
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            Assert.fail((String)("byte arrays differ (at position " + i + ")"));
        }
    }
}

