/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.ejbql;

import java.util.Collection;
import java.util.Iterator;
import org.apache.cayenne.access.translator.ejbql.EJBQLMultiColumnOperand;
import org.apache.cayenne.access.translator.ejbql.EJBQLPathTranslator;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslationContext;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLException;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.ClassDescriptor;

class EJBQLGroupByTranslator
extends EJBQLBaseVisitor {
    private EJBQLTranslationContext context;
    private int itemCount;

    EJBQLGroupByTranslator(EJBQLTranslationContext context) {
        this.context = context;
    }

    @Override
    public boolean visitIdentifier(EJBQLExpression expression) {
        if (this.itemCount++ > 0) {
            this.context.append(',');
        }
        expression.visit(this.context.getTranslatorFactory().getIdentifierColumnsTranslator(this.context));
        return false;
    }

    @Override
    public boolean visitPath(EJBQLExpression expression, int finishedChildIndex) {
        if (this.itemCount++ > 0) {
            this.context.append(',');
        }
        EJBQLPathTranslator childVisitor = new EJBQLPathTranslator(this.context){

            @Override
            protected void appendMultiColumnPath(EJBQLMultiColumnOperand operand) {
                throw new EJBQLException("Can't GROUP BY on multi-column paths or objects", new Object[0]);
            }

            @Override
            public boolean visitIdentificationVariable(EJBQLExpression expression) {
                String idVariableAbsolutePath = this.fullPath + "." + expression.getText();
                ClassDescriptor descriptor = EJBQLGroupByTranslator.this.context.getEntityDescriptor(idVariableAbsolutePath);
                if (descriptor != null) {
                    this.lastAlias = EJBQLGroupByTranslator.this.context.getTableAlias(idVariableAbsolutePath, EJBQLGroupByTranslator.this.context.getQuotingStrategy().quotedFullyQualifiedName(descriptor.getEntity().getDbEntity()));
                }
                this.lastPathComponent = expression.getText();
                this.fullPath = this.fullPath + '.' + this.lastPathComponent;
                return true;
            }

            @Override
            protected void processTerminatingRelationship(ObjRelationship relationship) {
                Collection<DbAttribute> dbAttr = relationship.getTargetEntity().getDbEntity().getAttributes();
                DbRelationship dbRelationship = relationship.getDbRelationships().get(0);
                DbEntity table = dbRelationship.getTargetEntity();
                Iterator<DbAttribute> it = dbAttr.iterator();
                String alias = this.lastAlias != null ? this.lastAlias : EJBQLGroupByTranslator.this.context.getTableAlias(this.idPath, EJBQLGroupByTranslator.this.context.getQuotingStrategy().quotedFullyQualifiedName(table));
                boolean first = true;
                while (it.hasNext()) {
                    EJBQLGroupByTranslator.this.context.append(!first ? ", " : " ");
                    DbAttribute dbAttribute = it.next();
                    EJBQLGroupByTranslator.this.context.append(alias).append('.').append(EJBQLGroupByTranslator.this.context.getQuotingStrategy().quotedName(dbAttribute));
                    first = false;
                }
            }
        };
        expression.visit(childVisitor);
        return false;
    }
}

