/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.loader.mapper;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.cayenne.access.loader.mapper.DbType;
import org.apache.cayenne.access.loader.mapper.Jdbc2JavaTypeMapper;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.util.Util;

public class DefaultJdbc2JavaTypeMapper
implements Jdbc2JavaTypeMapper {
    public static final int NOT_DEFINED = Integer.MAX_VALUE;
    public static final String JAVA_LONG = "java.lang.Long";
    public static final String JAVA_BYTES = "byte[]";
    public static final String JAVA_BOOLEAN = "java.lang.Boolean";
    public static final String JAVA_STRING = "java.lang.String";
    public static final String JAVA_SQLDATE = "java.sql.Date";
    public static final String JAVA_UTILDATE = "java.util.Date";
    public static final String JAVA_BIGDECIMAL = "java.math.BigDecimal";
    public static final String JAVA_DOUBLE = "java.lang.Double";
    public static final String JAVA_FLOAT = "java.lang.Float";
    public static final String JAVA_INTEGER = "java.lang.Integer";
    public static final String JAVA_SHORT = "java.lang.Short";
    public static final String JAVA_BYTE = "java.lang.Byte";
    public static final String JAVA_TIME = "java.sql.Time";
    public static final String JAVA_TIMESTAMP = "java.sql.Timestamp";
    public static final String JAVA_BLOB = "java.sql.Blob";
    private final Map<String, Integer> javaSqlEnum = new HashMap<String, Integer>();
    private final Map<DbType, String> mapping = new HashMap<DbType, String>();
    private final SortedSet<DbType> dbTypes = new TreeSet<DbType>();
    private Map<String, String> classToPrimitive;
    private Boolean usePrimitives;

    public DefaultJdbc2JavaTypeMapper() {
        this.add(-5, JAVA_LONG);
        this.add(-2, JAVA_BYTES);
        this.add(-7, JAVA_BOOLEAN);
        this.add(16, JAVA_BOOLEAN);
        this.add(2004, JAVA_BYTES);
        this.add(2005, JAVA_STRING);
        this.add(2011, JAVA_STRING);
        this.add(2009, JAVA_STRING);
        this.add(1, JAVA_STRING);
        this.add(-15, JAVA_STRING);
        this.add(91, JAVA_UTILDATE);
        this.add(3, JAVA_BIGDECIMAL);
        this.add(8, JAVA_DOUBLE);
        this.add(6, JAVA_FLOAT);
        this.add(4, JAVA_INTEGER);
        this.add(-1, JAVA_STRING);
        this.add(-16, JAVA_STRING);
        this.add(-4, JAVA_BYTES);
        this.add(2, JAVA_BIGDECIMAL);
        this.add(7, JAVA_FLOAT);
        this.add(5, JAVA_SHORT);
        this.add(-6, JAVA_SHORT);
        this.add(92, JAVA_UTILDATE);
        this.add(93, JAVA_UTILDATE);
        this.add(-3, JAVA_BYTES);
        this.add(12, JAVA_STRING);
        this.add(-9, JAVA_STRING);
        this.javaSqlEnum.put(JAVA_LONG, -5);
        this.javaSqlEnum.put(JAVA_BYTES, -2);
        this.javaSqlEnum.put(JAVA_BOOLEAN, -7);
        this.javaSqlEnum.put(JAVA_STRING, 12);
        this.javaSqlEnum.put(JAVA_SQLDATE, 91);
        this.javaSqlEnum.put(JAVA_UTILDATE, 91);
        this.javaSqlEnum.put(JAVA_TIMESTAMP, 93);
        this.javaSqlEnum.put(JAVA_BIGDECIMAL, 3);
        this.javaSqlEnum.put(JAVA_DOUBLE, 8);
        this.javaSqlEnum.put(JAVA_FLOAT, 6);
        this.javaSqlEnum.put(JAVA_INTEGER, 4);
        this.javaSqlEnum.put(JAVA_SHORT, 5);
        this.javaSqlEnum.put(JAVA_BYTE, 5);
        this.javaSqlEnum.put(JAVA_TIME, 92);
        this.javaSqlEnum.put(JAVA_TIMESTAMP, 93);
        this.javaSqlEnum.put("byte", -6);
        this.javaSqlEnum.put("int", 4);
        this.javaSqlEnum.put("short", 5);
        this.javaSqlEnum.put("char", 1);
        this.javaSqlEnum.put("double", 8);
        this.javaSqlEnum.put("long", -5);
        this.javaSqlEnum.put("float", 6);
        this.javaSqlEnum.put("boolean", -7);
        this.classToPrimitive = new HashMap<String, String>();
        this.classToPrimitive.put(Byte.class.getName(), "byte");
        this.classToPrimitive.put(Long.class.getName(), "long");
        this.classToPrimitive.put(Double.class.getName(), "double");
        this.classToPrimitive.put(Boolean.class.getName(), "boolean");
        this.classToPrimitive.put(Float.class.getName(), "float");
        this.classToPrimitive.put(Short.class.getName(), "short");
        this.classToPrimitive.put(Integer.class.getName(), "int");
    }

    @Override
    public int getJdbcTypeByJava(DbAttribute attribute, String className) {
        if (className == null) {
            return Integer.MAX_VALUE;
        }
        Integer type = this.javaSqlEnum.get(className);
        if (type != null) {
            return type;
        }
        try {
            return this.getSqlTypeByJava(attribute, Util.getJavaClass(className));
        }
        catch (Throwable th) {
            return Integer.MAX_VALUE;
        }
    }

    public void add(int jdbcType, String java) {
        this.add(new DbType(TypesMapping.getSqlNameByType(jdbcType)), java);
    }

    @Override
    public void add(DbType type, String java) {
        this.mapping.put(type, java);
        this.dbTypes.add(type);
    }

    protected int getSqlTypeByJava(DbAttribute attribute, Class<?> javaClass) {
        if (javaClass == null) {
            return Integer.MAX_VALUE;
        }
        for (Class<?> aClass = javaClass; aClass != null; aClass = aClass.getSuperclass()) {
            String name = aClass.isArray() ? aClass.getComponentType().getName() + "[]" : aClass.getName();
            Integer type = this.javaSqlEnum.get(name);
            if (type == null) continue;
            return ((Number)type).intValue();
        }
        if (javaClass.isArray()) {
            Class<?> elementType = javaClass.getComponentType();
            if (Character.class.isAssignableFrom(elementType) || Character.TYPE.isAssignableFrom(elementType)) {
                return 12;
            }
            if (Byte.class.isAssignableFrom(elementType) || Byte.TYPE.isAssignableFrom(elementType)) {
                return -3;
            }
        }
        if (Calendar.class.isAssignableFrom(javaClass)) {
            return 93;
        }
        if (BigInteger.class.isAssignableFrom(javaClass)) {
            return -5;
        }
        if (Serializable.class.isAssignableFrom(javaClass)) {
            return -3;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public String getJavaByJdbcType(DbAttribute attribute, int type) {
        String primitive;
        String jdbcType = TypesMapping.getSqlNameByType(type);
        DbType dbType = attribute != null ? new DbType(jdbcType, attribute.getMaxLength(), attribute.getAttributePrecision(), attribute.getScale(), attribute.isMandatory()) : new DbType(jdbcType);
        String typeName = this.getJavaByJdbcType(dbType);
        if (this.usePrimitives != null && this.usePrimitives.booleanValue() && (primitive = this.classToPrimitive.get(typeName)) != null) {
            return primitive;
        }
        return typeName;
    }

    public String getJavaByJdbcType(DbType type) {
        for (DbType t : this.dbTypes) {
            if (!t.isCover(type)) continue;
            return this.mapping.get(t);
        }
        return null;
    }

    public Boolean getUsePrimitives() {
        return this.usePrimitives;
    }

    public void setUsePrimitives(Boolean usePrimitives) {
        this.usePrimitives = usePrimitives;
    }
}

