/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.loader.mapper;

import org.apache.cayenne.util.EqualsBuilder;
import org.apache.cayenne.util.HashCodeBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DbType
implements Comparable<DbType> {
    private static final Log LOG = LogFactory.getLog(DbType.class);
    public final String jdbc;
    public final Integer length;
    public final Integer precision;
    public final Integer scale;
    public final Boolean notNull;

    public DbType(String jdbc) {
        this(jdbc, null, null, null, null);
    }

    public DbType(String jdbc, Integer length, Integer precision, Integer scale, Boolean notNull) {
        if (StringUtils.isBlank((String)jdbc)) {
            throw new IllegalArgumentException("Jdbc type can't be null");
        }
        this.jdbc = jdbc;
        this.length = this.getValidInt(length);
        this.precision = this.getValidInt(precision);
        this.scale = this.getValidInt(scale);
        this.notNull = notNull;
    }

    public String getJdbc() {
        return this.jdbc;
    }

    public Integer getLength() {
        return this.length;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public Boolean getNotNull() {
        return this.notNull;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DbType rhs = (DbType)obj;
        return new EqualsBuilder().append(this.jdbc, rhs.jdbc).append(this.length, rhs.length).append(this.precision, rhs.precision).append(this.scale, rhs.scale).append(this.notNull, rhs.notNull).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.jdbc).append(this.length).append(this.precision).append(this.scale).append(this.notNull).toHashCode();
    }

    public String toString() {
        String res = this.jdbc;
        String len = "*";
        if (this.isPositive(this.length)) {
            len = this.length.toString();
        }
        if (this.isPositive(this.precision)) {
            len = this.precision.toString();
        }
        res = res + " (" + len;
        if (this.isPositive(this.scale)) {
            res = res + ", " + this.scale;
        }
        res = res + ")";
        if (this.notNull != null && this.notNull.booleanValue()) {
            res = res + " NOT NULL";
        }
        return res;
    }

    private boolean isPositive(Integer num) {
        return num != null && num > 0;
    }

    private Integer getValidInt(Integer num) {
        if (num == null || num > 0) {
            return num;
        }
        LOG.warn((Object)("Invalid int value '" + num + "'"));
        return null;
    }

    @Override
    public int compareTo(DbType dbType) {
        return new CompareToBuilder().append((Object)dbType.jdbc, (Object)this.jdbc).append(dbType.getSpecificity(), this.getSpecificity()).append((Object)dbType.length, (Object)this.length).append((Object)dbType.precision, (Object)this.precision).append((Object)dbType.scale, (Object)this.scale).append((Object)dbType.notNull, (Object)this.notNull).toComparison();
    }

    private int getSpecificity() {
        int res = 0;
        if (this.isPositive(this.length)) {
            res += 100;
        }
        if (this.isPositive(this.precision)) {
            res += 100;
        }
        if (this.isPositive(this.scale)) {
            res += 10;
        }
        if (this.notNull != null) {
            res += 5;
        }
        return res;
    }

    public boolean isCover(DbType type) {
        return this.jdbc.equals(type.jdbc) && (this.isCover(this.length, type.length) || this.length == null && type.length == null && this.isCover(this.precision, type.precision)) && this.isCover(this.scale, type.scale) && this.isCover(this.notNull, type.notNull);
    }

    private boolean isCover(Object a, Object b) {
        return a == null || a.equals(b);
    }
}

