/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.loader.filters;

import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.access.loader.filters.DbPath;
import org.apache.cayenne.access.loader.filters.EntityFilters;
import org.apache.cayenne.access.loader.filters.FilterFactory;
import org.apache.cayenne.access.loader.filters.FiltersConfig;
import org.apache.cayenne.access.loader.filters.FiltersFactory;
import org.junit.Assert;
import org.junit.Test;

public class FiltersConfigTest {
    @Test
    public void testSorting() throws Exception {
        FiltersConfig filters = new FiltersConfig(this.entityFilter("", ""), this.entityFilter("aaa", ""), this.entityFilter("aa", ""), this.entityFilter("aa", "a"), this.entityFilter("aa", "aa"), this.entityFilter("aa", "aa"), this.entityFilter("b", "b"));
        Iterator<DbPath> iterator = filters.getDbPaths().iterator();
        Assert.assertEquals((Object)FiltersFactory.path("", ""), (Object)iterator.next());
        Assert.assertEquals((Object)FiltersFactory.path("aa", ""), (Object)iterator.next());
        Assert.assertEquals((Object)FiltersFactory.path("aa", "a"), (Object)iterator.next());
        Assert.assertEquals((Object)FiltersFactory.path("aa", "aa"), (Object)iterator.next());
        Assert.assertEquals((Object)FiltersFactory.path("aaa", ""), (Object)iterator.next());
        Assert.assertEquals((Object)FiltersFactory.path("b", "b"), (Object)iterator.next());
    }

    private EntityFilters entityFilter(String s, String s1) {
        return new EntityFilters(new DbPath(s, s1), FilterFactory.include("IncludeTable"), FilterFactory.TRUE, FilterFactory.TRUE);
    }

    @Test
    public void testActionsWithEmptyCatalog() throws Exception {
        FiltersConfig filters = new FiltersConfig(this.entityFilter(null, null), this.entityFilter("aaa", null), this.entityFilter("aa", null));
        List<DbPath> actions = filters.pathsForQueries();
        Assert.assertEquals((long)1L, (long)actions.size());
        Assert.assertEquals((Object)FiltersFactory.path(), (Object)actions.get(0));
    }

    @Test
    public void testActionsWithEmptySchemas() throws Exception {
        FiltersConfig filters = new FiltersConfig(this.entityFilter("aaa", null), this.entityFilter("aaa", "11"), this.entityFilter("aa", null), this.entityFilter("aa", "a"), this.entityFilter("aa", "aa"), this.entityFilter("aa", "aa"));
        List<DbPath> actions = filters.pathsForQueries();
        Assert.assertEquals((long)2L, (long)actions.size());
        Assert.assertEquals((Object)FiltersFactory.path("aa", null), (Object)actions.get(0));
        Assert.assertEquals((Object)FiltersFactory.path("aaa", null), (Object)actions.get(1));
    }

    @Test
    public void testActionsWithSchemas() throws Exception {
        FiltersConfig filters = new FiltersConfig(this.entityFilter("aaa", ""), this.entityFilter("aa", "a"), this.entityFilter("aa", "aa"), this.entityFilter("aa", "aa"), this.entityFilter("aa", "b"), this.entityFilter("aa", "b"), this.entityFilter("aa", "b"));
        List<DbPath> actions = filters.pathsForQueries();
        Assert.assertEquals((long)4L, (long)actions.size());
        Assert.assertEquals((Object)FiltersFactory.path("aa", "a"), (Object)actions.get(0));
        Assert.assertEquals((Object)FiltersFactory.path("aa", "aa"), (Object)actions.get(1));
        Assert.assertEquals((Object)FiltersFactory.path("aa", "b"), (Object)actions.get(2));
        Assert.assertEquals((Object)FiltersFactory.path("aaa", ""), (Object)actions.get(3));
    }

    @Test
    public void testActionsWithSchemasAndEmptyCatalog() throws Exception {
        FiltersConfig filters = new FiltersConfig(this.entityFilter("", "a"), this.entityFilter("", "aa"), this.entityFilter("", "aa"), this.entityFilter("", "b"), this.entityFilter("", "b"), this.entityFilter("", "b"));
        List<DbPath> actions = filters.pathsForQueries();
        Assert.assertEquals((long)3L, (long)actions.size());
        Assert.assertEquals((Object)FiltersFactory.path("", "b"), (Object)actions.get(2));
        Assert.assertEquals((Object)FiltersFactory.path("", "aa"), (Object)actions.get(1));
        Assert.assertEquals((Object)FiltersFactory.path("", "a"), (Object)actions.get(0));
    }

    @Test
    public void testFiltersOneFilter() throws Exception {
        FiltersConfig filters = new FiltersConfig(FiltersFactory.eFilters(FiltersFactory.path("", "a"), FilterFactory.include("table")), this.entityFilter("", "aa"), this.entityFilter("", "aa"), this.entityFilter("", "b"), this.entityFilter("", "b"), this.entityFilter("", "b"));
        Assert.assertEquals((Object)FiltersFactory.eFilters(FiltersFactory.path("", "a"), FilterFactory.include("table")), (Object)filters.filter(FiltersFactory.path("", "a")));
    }

    @Test
    public void testFiltersJoinFilters() throws Exception {
        FiltersConfig filters = new FiltersConfig(FiltersFactory.eFilters(FiltersFactory.path("", "a"), FilterFactory.include("table")), FiltersFactory.eFilters(FiltersFactory.path("", "a"), FilterFactory.exclude("table")), this.entityFilter("", "aa"), this.entityFilter("", "aa"));
        Assert.assertEquals((Object)FiltersFactory.eFilters(FiltersFactory.path("", "a"), FilterFactory.list(FilterFactory.include("table"), FilterFactory.exclude("table"))), (Object)filters.filter(FiltersFactory.path("", "a")));
        Assert.assertEquals((Object)this.entityFilter("", "aa"), (Object)filters.filter(FiltersFactory.path("", "aa")));
    }

    @Test
    public void testFiltersJoinFiltersWithNull() throws Exception {
        FiltersConfig filters = new FiltersConfig(FiltersFactory.eFilters(FiltersFactory.path("", "a"), FilterFactory.include("table")), FiltersFactory.eFilters(FiltersFactory.path("", "a"), FilterFactory.exclude("table")), FiltersFactory.eFilters(FiltersFactory.path("", "a"), null));
        Assert.assertEquals((Object)FiltersFactory.eFilters(FiltersFactory.path("", "a"), FilterFactory.list(FilterFactory.include("table"), FilterFactory.exclude("table"))), (Object)filters.filter(FiltersFactory.path("", "a")));
    }

    @Test
    public void testFiltersTopLevelTables() throws Exception {
        FiltersConfig filters = new FiltersConfig(FiltersFactory.eFilters(FiltersFactory.path(null, null), FilterFactory.include("TableName")));
        Assert.assertEquals((Object)FiltersFactory.eFilters(FiltersFactory.path(null, null), FilterFactory.include("TableName")), (Object)filters.filter(FiltersFactory.path("", "APP")));
    }

    @Test
    public void testFiltersFor2Schemas() throws Exception {
        FiltersConfig filters = new FiltersConfig(FiltersFactory.eFilters(FiltersFactory.path(null, "schema_01"), FilterFactory.include("TableName_01")), FiltersFactory.eFilters(FiltersFactory.path(null, "schema_02"), FilterFactory.include("TableName_01")));
        Assert.assertEquals((Object)FiltersFactory.eFilters(FiltersFactory.path(null, "schema_01"), FilterFactory.include("TableName_01")), (Object)filters.filter(FiltersFactory.path("", "schema_01")));
        Assert.assertEquals((String)"In case we don't have filter that cover path we should return null filter ", (Object)FiltersFactory.eFilters(FiltersFactory.path("", "app"), null), (Object)filters.filter(FiltersFactory.path("", "app")));
    }
}

