/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.loader.filters;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.loader.filters.DbPath;
import org.apache.cayenne.access.loader.filters.EntityFilters;

public class FiltersConfig {
    private final List<DbPath> dbPaths = new LinkedList<DbPath>();
    private final Map<DbPath, EntityFilters> filters = new HashMap<DbPath, EntityFilters>();
    private List<DbPath> pathsForQueries;

    public FiltersConfig(EntityFilters ... filters) {
        this(Arrays.asList(filters));
    }

    public FiltersConfig(Collection<EntityFilters> filters) {
        for (EntityFilters filter : filters) {
            if (filter == null) continue;
            DbPath path = filter.getDbPath();
            if (this.dbPaths.contains(path)) {
                this.filters.put(path, this.filters.get(path).join(filter));
                continue;
            }
            this.dbPaths.add(path);
            this.filters.put(path, filter);
        }
        Collections.sort(this.dbPaths);
    }

    public List<DbPath> pathsForQueries() {
        if (this.pathsForQueries != null) {
            return this.pathsForQueries;
        }
        this.pathsForQueries = new LinkedList<DbPath>();
        if (this.filters.isEmpty()) {
            return this.pathsForQueries;
        }
        boolean save = true;
        String catalog = null;
        String schema = null;
        for (DbPath path : this.dbPaths) {
            if (save || catalog != null && !catalog.equals(path.catalog)) {
                catalog = path.catalog;
                schema = null;
                save = true;
            }
            if (save || schema != null && !schema.equals(path.schema)) {
                schema = path.schema;
                save = true;
            }
            if (!save) continue;
            save = false;
            this.pathsForQueries.add(new DbPath(catalog, schema));
        }
        return this.pathsForQueries;
    }

    public EntityFilters filter(DbPath path) {
        EntityFilters res = new EntityFilters(path);
        for (Map.Entry<DbPath, EntityFilters> entry : this.filters.entrySet()) {
            if (!entry.getKey().isCover(path)) continue;
            res = res.join(entry.getValue());
        }
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Map<DbPath, EntityFilters> filters = ((FiltersConfig)o).filters;
        if (this.filters.size() != filters.size()) {
            return false;
        }
        for (Map.Entry<DbPath, EntityFilters> entry : this.filters.entrySet()) {
            EntityFilters f = filters.get(entry.getKey());
            if (f != null && f.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        for (DbPath dbPath : this.dbPaths) {
            res.append("    ").append(dbPath).append(" -> ").append(this.filters.get(dbPath)).append("\n");
        }
        return res.toString();
    }

    public int hashCode() {
        return this.filters.hashCode();
    }

    public List<DbPath> getDbPaths() {
        return this.dbPaths;
    }
}

