/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.loader.filters;

import java.util.regex.Pattern;
import org.apache.cayenne.access.loader.filters.ExcludeFilter;
import org.apache.cayenne.access.loader.filters.Filter;
import org.apache.cayenne.access.loader.filters.IncludeFilter;

public class FilterFactory {
    public static Filter<String> TRUE = new Filter<String>(){

        @Override
        public boolean isInclude(String obj) {
            return true;
        }

        @Override
        public Filter<String> join(Filter<String> filter) {
            return filter == null || NULL.equals(filter) ? this : filter;
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass();
        }

        public String toString() {
            return "true";
        }
    };
    public static Filter<String> NULL = new Filter<String>(){

        @Override
        public boolean isInclude(String obj) {
            return false;
        }

        @Override
        public Filter<String> join(Filter<String> filter) {
            return filter == null ? this : filter;
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass();
        }

        public String toString() {
            return "null";
        }
    };

    public static Filter<String> include(String tablePattern) {
        return new IncludeFilter(FilterFactory.pattern(tablePattern));
    }

    public static Filter<String> exclude(String tablePattern) {
        return new ExcludeFilter(FilterFactory.pattern(tablePattern));
    }

    public static Filter<String> list(Filter<String> ... filters) {
        Filter<String> res = NULL;
        for (Filter<String> filter : filters) {
            res = res.join(filter);
        }
        return res;
    }

    public static Pattern pattern(String tablePattern) {
        return Pattern.compile(tablePattern, 2);
    }
}

