/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.loader.filters;

import org.apache.cayenne.access.loader.filters.DbPath;
import org.apache.cayenne.access.loader.filters.Filter;
import org.apache.cayenne.access.loader.filters.FilterFactory;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.util.EqualsBuilder;
import org.apache.cayenne.util.HashCodeBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EntityFilters {
    private static final Log LOG = LogFactory.getLog(Filter.class);
    private final DbPath dbPath;
    private final Filter<String> tableFilters;
    private final Filter<String> columnFilters;
    private final Filter<String> proceduresFilters;

    public EntityFilters(DbPath dbPath) {
        this(dbPath, FilterFactory.NULL, FilterFactory.NULL, FilterFactory.NULL);
    }

    public EntityFilters(DbPath dbPath, Filter<String> tableFilters, Filter<String> columnFilters, Filter<String> proceduresFilters) {
        this.dbPath = dbPath;
        this.tableFilters = this.set(tableFilters);
        this.columnFilters = this.set(columnFilters);
        this.proceduresFilters = this.set(proceduresFilters);
    }

    public boolean isEmpty() {
        return !(this.tableFilters != null && !FilterFactory.NULL.equals(this.tableFilters) || this.columnFilters != null && !FilterFactory.NULL.equals(this.columnFilters) || this.proceduresFilters != null && !FilterFactory.NULL.equals(this.proceduresFilters));
    }

    public boolean isDefault() {
        return this.dbPath == null || DbPath.EMPTY.equals(this.dbPath) && this.tableFilters != null && FilterFactory.TRUE.equals(this.tableFilters) && this.columnFilters != null && FilterFactory.TRUE.equals(this.columnFilters) && (this.proceduresFilters == null || FilterFactory.NULL.equals(this.proceduresFilters));
    }

    public DbPath getDbPath() {
        return this.dbPath;
    }

    private Filter<String> set(Filter<String> tableFilters) {
        return tableFilters == null ? FilterFactory.NULL : tableFilters;
    }

    public Filter<DbEntity> tableFilter() {
        return new DbEntityFilter(this.dbPath, this.tableFilters);
    }

    public Filter<DbAttribute> columnFilter() {
        return new DbAttributeFilter(this.dbPath, this.columnFilters);
    }

    public Filter<Procedure> procedureFilter() {
        return new ProcedureFilter(this.dbPath, this.proceduresFilters);
    }

    public EntityFilters join(EntityFilters filter) {
        if (filter == null) {
            return this;
        }
        DbPath path = this.dbPath == null ? filter.dbPath : (filter.dbPath == null ? this.dbPath : this.dbPath.merge(filter.dbPath));
        return new EntityFilters(path, this.tableFilters.join(filter.tableFilters), this.columnFilters.join(filter.columnFilters), this.proceduresFilters.join(filter.proceduresFilters));
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append(this.dbPath).append(":\n");
        if (this.tableFilters != null) {
            res.append("    Table: ").append(this.tableFilters).append("\n");
        }
        if (this.columnFilters != null) {
            res.append("    Column: ").append(this.columnFilters).append("\n");
        }
        if (this.proceduresFilters != null) {
            res.append("    Procedures: ").append(this.proceduresFilters).append("\n");
        }
        return res.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        EntityFilters rhs = (EntityFilters)obj;
        return new EqualsBuilder().append(this.dbPath, rhs.dbPath).append(this.tableFilters, rhs.tableFilters).append(this.columnFilters, rhs.columnFilters).append(this.proceduresFilters, rhs.proceduresFilters).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.dbPath).append(this.tableFilters).append(this.columnFilters).append(this.proceduresFilters).toHashCode();
    }

    public static final class Builder {
        private String catalog;
        private String schema;
        private Filter<String> tableFilters = FilterFactory.TRUE;
        private Filter<String> columnFilters = FilterFactory.TRUE;
        private Filter<String> proceduresFilters = FilterFactory.NULL;

        public Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public String catalog() {
            return this.catalog;
        }

        public String schema() {
            return this.schema;
        }

        public Builder includeTables(String tableFilters) {
            if (StringUtils.isBlank((String)tableFilters)) {
                return this;
            }
            this.tableFilters = this.includeFilter(tableFilters, this.tableFilters);
            return this;
        }

        public Builder includeColumns(String columnFilters) {
            if (StringUtils.isBlank((String)columnFilters)) {
                return this;
            }
            this.columnFilters = this.includeFilter(columnFilters, this.columnFilters);
            return this;
        }

        public Builder includeProcedures(String proceduresFilters) {
            if (StringUtils.isBlank((String)proceduresFilters)) {
                return this;
            }
            this.proceduresFilters = this.includeFilter(proceduresFilters, this.proceduresFilters);
            return this;
        }

        private Filter<String> includeFilter(String tableFilters, Filter<String> filter) {
            for (String pattern : tableFilters.split(",")) {
                filter = filter.join(FilterFactory.include(Builder.transform(pattern)));
            }
            return filter;
        }

        public Builder excludeTables(String tableFilters) {
            if (StringUtils.isBlank((String)tableFilters)) {
                return this;
            }
            this.tableFilters = this.excludeFilter(tableFilters, this.tableFilters);
            return this;
        }

        public Builder excludeColumns(String columnFilters) {
            if (StringUtils.isBlank((String)columnFilters)) {
                return this;
            }
            this.columnFilters = this.excludeFilter(columnFilters, this.columnFilters);
            return this;
        }

        public Builder excludeProcedures(String proceduresFilters) {
            if (StringUtils.isBlank((String)proceduresFilters)) {
                return this;
            }
            this.proceduresFilters = this.excludeFilter(proceduresFilters, this.proceduresFilters);
            return this;
        }

        private Filter<String> excludeFilter(String tableFilters, Filter<String> filter) {
            for (String pattern : tableFilters.split(",")) {
                filter = filter.join(FilterFactory.exclude(Builder.transform(pattern)));
            }
            return filter;
        }

        private static String transform(String pattern) {
            return "^" + pattern.replaceAll("[*?]", ".$0") + "$";
        }

        public Filter<String> tableFilters() {
            return this.tableFilters;
        }

        public Filter<String> columnFilters() {
            return this.columnFilters;
        }

        public Filter<String> proceduresFilters() {
            return this.proceduresFilters;
        }

        public void setTableFilters(Filter<String> tableFilters) {
            this.tableFilters = tableFilters;
        }

        public void setColumnFilters(Filter<String> columnFilters) {
            this.columnFilters = columnFilters;
        }

        public void setProceduresFilters(Filter<String> proceduresFilters) {
            this.proceduresFilters = proceduresFilters;
        }

        public EntityFilters build() {
            return new EntityFilters(new DbPath(this.catalog, this.schema), this.tableFilters, this.columnFilters, this.proceduresFilters);
        }
    }

    private static class ProcedureFilter
    extends EntityFilter<Procedure> {
        public ProcedureFilter(DbPath dbPath, Filter<String> filter) {
            super(dbPath, filter);
        }

        @Override
        public boolean isInclude(Procedure obj) {
            if (LOG.isTraceEnabled() && this.getDbPath().isCover(obj.getCatalog(), obj.getSchema())) {
                LOG.warn((Object)("Attempt to apply inconvenient filter '" + this + "' for procedure '" + obj + "'"));
            }
            return this.getFilter().isInclude(obj.getName());
        }

        @Override
        public EntityFilter<Procedure> create(DbPath dbPath, Filter<String> filter) {
            return new ProcedureFilter(dbPath, filter);
        }
    }

    private static class DbAttributeFilter
    extends EntityFilter<DbAttribute> {
        public DbAttributeFilter(DbPath dbPath, Filter<String> filter) {
            super(dbPath, filter);
        }

        @Override
        public boolean isInclude(DbAttribute obj) {
            DbEntity entity = obj.getEntity();
            if (LOG.isTraceEnabled() && this.getDbPath().isCover(entity.getCatalog(), entity.getSchema(), entity.getName())) {
                LOG.warn((Object)("Attempt to apply inconvenient filter '" + this + "' for attribute '" + obj + "'"));
            }
            return this.getFilter().isInclude(obj.getName());
        }

        @Override
        public EntityFilter<DbAttribute> create(DbPath dbPath, Filter<String> filter) {
            return new DbAttributeFilter(dbPath, filter);
        }
    }

    private static class DbEntityFilter
    extends EntityFilter<DbEntity> {
        public DbEntityFilter(DbPath dbPath, Filter<String> filter) {
            super(dbPath, filter);
        }

        @Override
        public boolean isInclude(DbEntity obj) {
            if (LOG.isTraceEnabled() && this.getDbPath().isCover(obj.getCatalog(), obj.getSchema())) {
                LOG.warn((Object)("Attempt to apply inconvenient filter '" + this + "' for dbEntity '" + obj + "'"));
            }
            return this.getFilter().isInclude(obj.getName());
        }

        @Override
        public EntityFilter<DbEntity> create(DbPath dbPath, Filter<String> filter) {
            return new DbEntityFilter(dbPath, filter);
        }
    }

    private static abstract class EntityFilter<T>
    implements Filter<T> {
        private final DbPath dbPath;
        private final Filter<String> filter;

        protected EntityFilter(DbPath dbPath, Filter<String> filter) {
            this.dbPath = dbPath;
            this.filter = filter;
        }

        DbPath getDbPath() {
            return this.dbPath;
        }

        Filter<String> getFilter() {
            return this.filter;
        }

        @Override
        public EntityFilter<T> join(Filter<T> filter) {
            DbPath dbPath;
            if (!(filter instanceof EntityFilter)) {
                throw new IllegalArgumentException("Unexpected filter join '" + this + "' and '" + filter + "'");
            }
            EntityFilter entityFilter = (EntityFilter)filter;
            if (entityFilter.dbPath.isCover(this.dbPath)) {
                dbPath = entityFilter.dbPath;
            } else if (this.dbPath.isCover(entityFilter.dbPath)) {
                dbPath = this.dbPath;
            } else {
                throw new IllegalArgumentException("Attempt to merge filter with incompatible tuples: '" + entityFilter.dbPath + "'");
            }
            return this.create(dbPath, this.filter.join(entityFilter.filter));
        }

        public String toString() {
            return this.getClass().getSimpleName() + " (" + this.dbPath + " -> " + this.filter + ")";
        }

        public abstract EntityFilter<T> create(DbPath var1, Filter<String> var2);

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o instanceof Filter) {
                return this.filter.equals(o);
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            return this.filter.equals(((EntityFilter)o).filter);
        }

        public int hashCode() {
            return this.filter.hashCode();
        }
    }
}

