/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.loader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.cayenne.access.loader.NameFilter;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.commons.logging.Log;

public class NamePatternMatcher
implements NameFilter {
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final Pattern COMMA = Pattern.compile(",");
    private final Pattern[] itemIncludeFilters;
    private final Pattern[] itemExcludeFilters;

    public static NamePatternMatcher build(Log logger, String includePattern, String excludePattern) {
        return new NamePatternMatcher(NamePatternMatcher.createPatterns(logger, includePattern), NamePatternMatcher.createPatterns(logger, excludePattern));
    }

    public NamePatternMatcher(Pattern[] itemIncludeFilters, Pattern[] itemExcludeFilters) {
        this.itemIncludeFilters = itemIncludeFilters;
        this.itemExcludeFilters = itemExcludeFilters;
    }

    @Deprecated
    public List<?> filter(List<?> items) {
        if (items == null || items.isEmpty()) {
            return items;
        }
        if (this.itemIncludeFilters.length == 0 && this.itemExcludeFilters.length == 0) {
            return items;
        }
        Iterator<?> it = items.iterator();
        while (it.hasNext()) {
            CayenneMapEntry entity = (CayenneMapEntry)it.next();
            if (!this.passedIncludeFilter(entity.getName())) {
                it.remove();
                continue;
            }
            if (this.passedExcludeFilter(entity.getName())) continue;
            it.remove();
        }
        return items;
    }

    public static Pattern[] createPatterns(Log logger, String patternString) {
        if (patternString == null) {
            return new Pattern[0];
        }
        String[] patternStrings = NamePatternMatcher.tokenizePattern(patternString);
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(patternStrings.length);
        for (String patternString1 : patternStrings) {
            try {
                patterns.add(Pattern.compile(patternString1));
            }
            catch (PatternSyntaxException e) {
                if (logger == null) continue;
                logger.warn((Object)("Ignoring invalid pattern [" + patternString1 + "], reason: " + e.getMessage()));
            }
        }
        return patterns.toArray(new Pattern[patterns.size()]);
    }

    public static String[] tokenizePattern(String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return EMPTY_ARRAY;
        }
        String[] patterns = COMMA.split(pattern);
        if (patterns.length == 0) {
            return EMPTY_ARRAY;
        }
        for (int i = 0; i < patterns.length; ++i) {
            patterns[i] = "^" + patterns[i].replaceAll("[*?]", ".$0") + "$";
        }
        return patterns;
    }

    @Override
    public boolean isIncluded(String string) {
        return this.passedIncludeFilter(string) && this.passedExcludeFilter(string);
    }

    private boolean passedIncludeFilter(String item) {
        if (this.itemIncludeFilters.length == 0) {
            return true;
        }
        for (Pattern itemIncludeFilter : this.itemIncludeFilters) {
            if (!itemIncludeFilter.matcher(item).find()) continue;
            return true;
        }
        return false;
    }

    private boolean passedExcludeFilter(String item) {
        if (this.itemExcludeFilters.length == 0) {
            return true;
        }
        for (Pattern itemExcludeFilter : this.itemExcludeFilters) {
            if (!itemExcludeFilter.matcher(item).find()) continue;
            return false;
        }
        return true;
    }

    public static String replaceWildcardInStringWithString(String wildcard, String pattern, String replacement) {
        if (pattern == null || wildcard == null) {
            return pattern;
        }
        StringBuilder buffer = new StringBuilder();
        int lastPos = 0;
        int wildCardPos = pattern.indexOf(wildcard);
        while (wildCardPos != -1) {
            if (lastPos != wildCardPos) {
                buffer.append(pattern.substring(lastPos, wildCardPos));
            }
            buffer.append(replacement);
            wildCardPos = pattern.indexOf(wildcard, lastPos += wildCardPos + wildcard.length());
        }
        if (lastPos < pattern.length()) {
            buffer.append(pattern.substring(lastPos));
        }
        return buffer.toString();
    }
}

