/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.loader;

import org.apache.cayenne.access.loader.filters.DbPath;
import org.apache.cayenne.access.loader.filters.EntityFilters;
import org.apache.cayenne.access.loader.filters.FilterFactory;
import org.apache.cayenne.access.loader.filters.FiltersConfig;

public class DbLoaderConfiguration {
    private String genericClassName;
    private String namingStrategy;
    private Boolean skipRelationshipsLoading;
    private Boolean skipPrimaryKeyLoading;
    private String[] tableTypes;
    private FiltersConfig filtersConfig;

    public String getGenericClassName() {
        return this.genericClassName;
    }

    public void setGenericClassName(String genericClassName) {
        this.genericClassName = genericClassName;
    }

    public String[] getTableTypes() {
        return this.tableTypes;
    }

    public void setTableTypes(String[] tableTypes) {
        this.tableTypes = tableTypes;
    }

    public String getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(String namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public FiltersConfig getFiltersConfig() {
        if (this.filtersConfig == null) {
            return new FiltersConfig(new EntityFilters(new DbPath(), FilterFactory.TRUE, FilterFactory.TRUE, FilterFactory.TRUE));
        }
        return this.filtersConfig;
    }

    public void setFiltersConfig(FiltersConfig filtersConfig) {
        this.filtersConfig = filtersConfig;
    }

    public boolean isSkipRelationshipsLoading() {
        return this.skipRelationshipsLoading != null && this.skipRelationshipsLoading != false;
    }

    public Boolean getSkipRelationshipsLoading() {
        return this.skipRelationshipsLoading;
    }

    public void setSkipRelationshipsLoading(Boolean skipRelationshipsLoading) {
        this.skipRelationshipsLoading = skipRelationshipsLoading;
    }

    public void setSkipPrimaryKeyLoading(Boolean skipPrimaryKeyLoading) {
        this.skipPrimaryKeyLoading = skipPrimaryKeyLoading;
    }

    public boolean getSkipPrimaryKeyLoading() {
        return this.skipPrimaryKeyLoading;
    }

    public boolean isSkipPrimaryKeyLoading() {
        return this.skipPrimaryKeyLoading != null && this.skipPrimaryKeyLoading != false;
    }

    public String toString() {
        String res = "EntitiesFilters: " + this.getFiltersConfig();
        if (this.isSkipRelationshipsLoading()) {
            res = res + "\n Skip Loading Relationships! \n";
        }
        if (this.isSkipPrimaryKeyLoading()) {
            res = res + "\n Skip Loading PrimaryKeys! \n";
        }
        return res;
    }
}

