/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.util.ResultIteratorIterator;

public class DistinctResultIterator<T>
implements ResultIterator<T> {
    protected ResultIterator<T> delegate;
    protected Set<Map<String, Object>> fetchedIds;
    protected DataRow nextDataRow;
    protected DbEntity defaultEntity;
    protected boolean compareFullRows;

    public DistinctResultIterator(ResultIterator<T> delegate, DbEntity defaultEntity, boolean compareFullRows) {
        if (delegate == null) {
            throw new NullPointerException("Null wrapped iterator.");
        }
        if (defaultEntity == null) {
            throw new NullPointerException("Null defaultEntity.");
        }
        this.delegate = delegate;
        this.defaultEntity = defaultEntity;
        this.fetchedIds = new HashSet<Map<String, Object>>();
        this.compareFullRows = compareFullRows;
        this.checkNextRow();
    }

    @Override
    public Iterator<T> iterator() {
        return new ResultIteratorIterator(this);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public List<T> allRows() {
        ArrayList<T> list = new ArrayList<T>();
        while (this.hasNextRow()) {
            list.add(this.nextRow());
        }
        return list;
    }

    @Override
    public boolean hasNextRow() {
        return this.nextDataRow != null;
    }

    @Override
    public T nextRow() {
        if (!this.hasNextRow()) {
            throw new NoSuchElementException("An attempt to read uninitialized row or past the end of the iterator.");
        }
        DataRow row = this.nextDataRow;
        this.checkNextRow();
        return (T)row;
    }

    @Override
    public void skipRow() {
        if (!this.hasNextRow()) {
            throw new NoSuchElementException("An attempt to read uninitialized row or past the end of the iterator.");
        }
        this.checkNextRow();
    }

    void checkNextRow() {
        if (this.compareFullRows) {
            this.checkNextUniqueRow();
        } else {
            this.checkNextRowWithUniqueId();
        }
    }

    void checkNextUniqueRow() {
        this.nextDataRow = null;
        while (this.delegate.hasNextRow()) {
            DataRow next = (DataRow)this.delegate.nextRow();
            if (!this.fetchedIds.add(next)) continue;
            this.nextDataRow = next;
            break;
        }
    }

    void checkNextRowWithUniqueId() {
        this.nextDataRow = null;
        while (this.delegate.hasNextRow()) {
            DataRow next = (DataRow)this.delegate.nextRow();
            HashMap id = new HashMap();
            for (DbAttribute pk : this.defaultEntity.getPrimaryKeys()) {
                id.put(pk.getName(), next.get(pk.getName()));
            }
            if (!this.fetchedIds.add(id)) continue;
            this.nextDataRow = next;
            break;
        }
    }
}

