/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ResultIterator;

public class ConnectionAwareResultIterator<T>
implements ResultIterator<T> {
    private ResultIterator<T> delegate;
    private Connection connection;
    private boolean closed;
    protected int rowCounter;

    public ConnectionAwareResultIterator(ResultIterator<T> delegate, Connection connection) {
        this.delegate = delegate;
        this.connection = connection;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.doClose();
            this.closed = true;
        }
    }

    protected void doClose() {
        StringBuilder errors = null;
        try {
            this.delegate.close();
        }
        catch (Exception e1) {
            if (errors == null) {
                errors = new StringBuilder();
            }
            errors.append("Error closing ResultSet: " + e1);
        }
        try {
            this.connection.close();
        }
        catch (SQLException e2) {
            if (errors == null) {
                errors = new StringBuilder();
            }
            errors.append("Error closing connection: " + e2);
        }
        if (errors != null) {
            throw new CayenneRuntimeException("Error closing ResultIterator: " + errors.toString(), new Object[0]);
        }
    }

    @Override
    public List<T> allRows() {
        return this.delegate.allRows();
    }

    @Override
    public boolean hasNextRow() {
        return this.delegate.hasNextRow();
    }

    @Override
    public T nextRow() {
        ++this.rowCounter;
        return this.delegate.nextRow();
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public void skipRow() {
        this.delegate.skipRow();
    }
}

