/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.OptimisticLockException;
import org.apache.cayenne.access.jdbc.BaseSQLAction;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.jdbc.JDBCResultIterator;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.jdbc.RowDescriptorBuilder;
import org.apache.cayenne.access.jdbc.reader.RowReader;
import org.apache.cayenne.access.translator.batch.BatchParameterBinding;
import org.apache.cayenne.access.translator.batch.BatchTranslator;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.BatchQueryRow;
import org.apache.cayenne.query.InsertBatchQuery;

public class BatchAction
extends BaseSQLAction {
    protected boolean runningAsBatch;
    protected BatchQuery query;
    protected RowDescriptor keyRowDescriptor;

    private static void bind(DbAdapter adapter, PreparedStatement statement, BatchParameterBinding[] bindings) throws SQLException, Exception {
        for (BatchParameterBinding b : bindings) {
            if (b.isExcluded()) continue;
            adapter.bindParameter(statement, b.getValue(), b.getStatementPosition(), b.getAttribute().getType(), b.getAttribute().getScale());
        }
    }

    public BatchAction(BatchQuery query, DataNode dataNode, boolean runningAsBatch) {
        super(dataNode);
        this.query = query;
        this.runningAsBatch = runningAsBatch;
    }

    public BatchQuery getQuery() {
        return this.query;
    }

    @Override
    public void performAction(Connection connection, OperationObserver observer) throws SQLException, Exception {
        BatchTranslator translator = this.createTranslator();
        boolean generatesKeys = this.hasGeneratedKeys();
        if (this.runningAsBatch && !generatesKeys) {
            this.runAsBatch(connection, translator, observer);
        } else {
            this.runAsIndividualQueries(connection, translator, observer, generatesKeys);
        }
    }

    protected BatchTranslator createTranslator() throws CayenneException {
        return this.dataNode.batchTranslator(this.query, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runAsBatch(Connection con, BatchTranslator translator, OperationObserver delegate) throws SQLException, Exception {
        String sql = translator.getSql();
        JdbcEventLogger logger = this.dataNode.getJdbcEventLogger();
        boolean isLoggable = logger.isLoggable();
        logger.logQuery(sql, Collections.EMPTY_LIST);
        DbAdapter adapter = this.dataNode.getAdapter();
        PreparedStatement statement = con.prepareStatement(sql);
        try {
            for (BatchQueryRow row : this.query.getRows()) {
                BatchParameterBinding[] bindings = translator.updateBindings(row);
                logger.logQueryParameters("batch bind", bindings);
                BatchAction.bind(adapter, statement, bindings);
                statement.addBatch();
            }
            int[] results = statement.executeBatch();
            delegate.nextBatchCount(this.query, results);
            if (isLoggable) {
                int totalUpdateCount = 0;
                for (int result : results) {
                    if (result < 0) {
                        totalUpdateCount = -2;
                        break;
                    }
                    totalUpdateCount += result;
                }
                logger.logUpdateCount(totalUpdateCount);
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runAsIndividualQueries(Connection connection, BatchTranslator translator, OperationObserver delegate, boolean generatesKeys) throws SQLException, Exception {
        JdbcEventLogger logger = this.dataNode.getJdbcEventLogger();
        boolean useOptimisticLock = this.query.isUsingOptimisticLocking();
        String queryStr = translator.getSql();
        logger.logQuery(queryStr, Collections.EMPTY_LIST);
        DbAdapter adapter = this.dataNode.getAdapter();
        PreparedStatement statement = generatesKeys ? connection.prepareStatement(queryStr, 1) : connection.prepareStatement(queryStr);
        try {
            for (BatchQueryRow row : this.query.getRows()) {
                BatchParameterBinding[] bindings = translator.updateBindings(row);
                logger.logQueryParameters("bind", bindings);
                BatchAction.bind(adapter, statement, bindings);
                int updated = statement.executeUpdate();
                if (useOptimisticLock && updated != 1) {
                    throw new OptimisticLockException(row.getObjectId(), this.query.getDbEntity(), queryStr, row.getQualifier());
                }
                delegate.nextCount(this.query, updated);
                if (generatesKeys) {
                    this.processGeneratedKeys(statement, delegate, row);
                }
                logger.logUpdateCount(updated);
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    protected boolean hasGeneratedKeys() {
        if (!this.dataNode.getAdapter().supportsGeneratedKeys()) {
            return false;
        }
        if (this.query instanceof InsertBatchQuery) {
            for (DbAttribute attr : this.query.getDbEntity().getGeneratedAttributes()) {
                if (!attr.isPrimaryKey()) continue;
                return true;
            }
        }
        return false;
    }

    protected void processGeneratedKeys(Statement statement, OperationObserver observer, BatchQueryRow row) throws SQLException, CayenneException {
        ResultSet keysRS = statement.getGeneratedKeys();
        RowDescriptorBuilder builder = new RowDescriptorBuilder();
        if (this.keyRowDescriptor == null) {
            Collection<DbAttribute> generated = this.query.getDbEntity().getGeneratedAttributes();
            if (generated.size() == 1) {
                DbAttribute key = generated.iterator().next();
                ColumnDescriptor[] columns = new ColumnDescriptor[]{new ColumnDescriptor(keysRS.getMetaData(), 1)};
                columns[0].setJdbcType(key.getType());
                columns[0].setJavaClass(TypesMapping.getJavaBySqlType(key.getType()));
                builder.setColumns(columns);
            } else {
                builder.setResultSet(keysRS);
            }
            this.keyRowDescriptor = builder.getDescriptor(this.dataNode.getAdapter().getExtendedTypes());
        }
        RowReader<?> rowReader = this.dataNode.rowReader(this.keyRowDescriptor, this.query.getMetaData(this.dataNode.getEntityResolver()), Collections.<ObjAttribute, ColumnDescriptor>emptyMap());
        JDBCResultIterator iterator = new JDBCResultIterator(null, keysRS, rowReader);
        observer.nextGeneratedRows(this.query, iterator, row.getObjectId());
    }
}

