/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.dbsync;

import java.util.Collections;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.dbsync.SchemaUpdateStrategyBase;
import org.apache.cayenne.access.dbsync.ThrowOnPartialOrCreateSchemaStrategy;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

@UseServerRuntime(value="cayenne-sus.xml")
public class ThrowOnPartialOrCreateSchemaStrategyIT
extends SchemaUpdateStrategyBase {
    @Test
    public void testMixedStrategyTableExist() throws Exception {
        this.createOneTable("SUS1");
        this.createOneTable("SUS2");
        String template = "SELECT #result('ARTIST_ID' 'int') FROM ARTIST ORDER BY ARTIST_ID";
        SQLTemplate query = new SQLTemplate(Object.class, template);
        this.setStrategy(ThrowOnPartialOrCreateSchemaStrategy.class);
        this.node.performQueries(Collections.singletonList(query), (OperationObserver)Mockito.mock(OperationObserver.class));
    }

    @Test
    public void testMixedStrategyTableNoExist() throws Exception {
        String template = "SELECT #result('id' 'int') FROM SUS1";
        SQLTemplate query = new SQLTemplate(Object.class, template);
        this.setStrategy(ThrowOnPartialOrCreateSchemaStrategy.class);
        this.node.performQueries(Collections.singletonList(query), (OperationObserver)Mockito.mock(OperationObserver.class));
        Map<String, Boolean> nameTables = this.tablesMap();
        Assert.assertTrue((boolean)nameTables.get("SUS1"));
        Assert.assertEquals((long)2L, (long)this.existingTables().size());
        this.node.performQueries(Collections.singletonList(query), (OperationObserver)Mockito.mock(OperationObserver.class));
        Assert.assertEquals((long)2L, (long)this.existingTables().size());
    }

    @Test
    public void testMixedStrategyWithOneTable() throws Exception {
        this.createOneTable("SUS1");
        this.setStrategy(ThrowOnPartialOrCreateSchemaStrategy.class);
        String template = "SELECT #result('ARTIST_ID' 'int') FROM ARTIST ORDER BY ARTIST_ID";
        SQLTemplate query = new SQLTemplate(Object.class, template);
        try {
            this.node.performQueries(Collections.singletonList(query), (OperationObserver)Mockito.mock(OperationObserver.class));
            Assert.assertEquals((long)1L, (long)this.existingTables().size());
            Assert.fail((String)"Must have thrown on partial schema");
        }
        catch (CayenneRuntimeException cayenneRuntimeException) {
            // empty catch block
        }
    }
}

