/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.Connection;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.tx.BaseTransaction;
import org.apache.cayenne.tx.CayenneTransaction;
import org.apache.cayenne.tx.Transaction;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class TransactionThreadIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private JdbcEventLogger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThreadConnectionReuseOnSelect() throws Exception {
        ConnectionCounterTx t = new ConnectionCounterTx(new CayenneTransaction(this.logger));
        BaseTransaction.bindThreadTransaction(t);
        try {
            SelectQuery<Artist> q1 = new SelectQuery<Artist>(Artist.class);
            this.context.performQuery(q1);
            Assert.assertEquals((long)1L, (long)t.connectionCount);
            SelectQuery<Artist> q2 = new SelectQuery<Artist>(Artist.class);
            this.context.performQuery(q2);
        }
        finally {
            BaseTransaction.bindThreadTransaction(null);
            t.commit();
        }
    }

    class ConnectionCounterTx
    implements Transaction {
        private Transaction delegate;
        int connectionCount;

        ConnectionCounterTx(Transaction delegate) {
            this.delegate = delegate;
        }

        @Override
        public void begin() {
            this.delegate.begin();
        }

        @Override
        public void commit() {
            this.delegate.commit();
        }

        @Override
        public void rollback() {
            this.delegate.rollback();
        }

        @Override
        public void setRollbackOnly() {
            this.delegate.setRollbackOnly();
        }

        @Override
        public boolean isRollbackOnly() {
            return this.delegate.isRollbackOnly();
        }

        @Override
        public Connection getConnection(String name) {
            return this.delegate.getConnection(name);
        }

        @Override
        public void addConnection(String name, Connection connection) {
            if (this.connectionCount++ > 0) {
                Assert.fail((String)"Invalid attempt to add connection");
            }
            this.delegate.addConnection(name, connection);
        }
    }
}

