/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Arrays;
import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.inheritance_people.AbstractPerson;
import org.apache.cayenne.testdo.inheritance_people.Address;
import org.apache.cayenne.testdo.inheritance_people.ClientCompany;
import org.apache.cayenne.testdo.inheritance_people.CustomerRepresentative;
import org.apache.cayenne.testdo.inheritance_people.Department;
import org.apache.cayenne.testdo.inheritance_people.Employee;
import org.apache.cayenne.testdo.inheritance_people.Manager;
import org.apache.cayenne.testdo.inheritance_people.PersonNotes;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.UnitTestClosure;
import org.apache.cayenne.unit.di.server.PeopleProjectCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SingleTableInheritanceIT
extends PeopleProjectCase {
    @Inject
    private DataContext context;
    @Inject
    private DataContext context2;
    @Inject
    private DataChannelInterceptor queryBlocker;
    private TableHelper tPerson;
    private TableHelper tAddress;
    private TableHelper tClientCompany;
    private TableHelper tDepartment;

    @Before
    public void setUp() {
        this.tAddress = new TableHelper(this.dbHelper, "ADDRESS");
        this.tAddress.setColumns(new String[]{"ADDRESS_ID", "CITY", "PERSON_ID"});
        this.tClientCompany = new TableHelper(this.dbHelper, "CLIENT_COMPANY");
        this.tClientCompany.setColumns(new String[]{"CLIENT_COMPANY_ID", "NAME"});
        this.tDepartment = new TableHelper(this.dbHelper, "DEPARTMENT");
        this.tDepartment.setColumns(new String[]{"DEPARTMENT_ID", "NAME"});
        this.tPerson = new TableHelper(this.dbHelper, "PERSON").setColumns(new String[]{"PERSON_ID", "NAME", "PERSON_TYPE", "SALARY", "CLIENT_COMPANY_ID", "DEPARTMENT_ID"}).setColumnTypes(new int[]{4, 12, 1, 6, 4, 4});
    }

    private void create2PersonDataSet() throws Exception {
        this.tPerson.insert(new Object[]{1, "E1", "EE", null, null, null});
        this.tPerson.insert(new Object[]{2, "E2", "EM", null, null, null});
    }

    private void create5PersonDataSet() throws Exception {
        this.tPerson.insert(new Object[]{1, "E1", "EE", null, null, null});
        this.tPerson.insert(new Object[]{2, "E2", "EM", null, null, null});
        this.tPerson.insert(new Object[]{3, "E3", "EE", null, null, null});
        this.tPerson.insert(new Object[]{4, "E4", "EM", null, null, null});
        this.tPerson.insert(new Object[]{5, "E5", "EE", null, null, null});
    }

    private void createSelectDataSet() throws Exception {
        this.tPerson.insert(new Object[]{1, "e1", "EE", 20000, null, null});
        this.tPerson.insert(new Object[]{2, "e2", "EE", 25000, null, null});
        this.tPerson.insert(new Object[]{3, "e3", "EE", 28000, null, null});
        this.tPerson.insert(new Object[]{4, "m1", "EM", 30000, null, null});
        this.tPerson.insert(new Object[]{5, "m2", "EM", 40000, null, null});
        this.tClientCompany.insert(new Object[]{1, "Citibank"});
        this.tPerson.insert(new Object[]{6, "c1", "C", null, 1, null});
    }

    private void createEmployeeAddressDataSet() throws Exception {
        this.tPerson.insert(new Object[]{1, "e1", "EE", 20000, null, null});
        this.tAddress.insert(new Object[]{1, "New York", 1});
    }

    private void createManagerAddressDataSet() throws Exception {
        this.tPerson.insert(new Object[]{4, "m1", "EM", 30000, null, null});
        this.tAddress.insert(new Object[]{1, "New York", 4});
    }

    private void createRepCompanyDataSet() throws Exception {
        this.tClientCompany.insert(new Object[]{1, "Citibank"});
        this.tPerson.insert(new Object[]{6, "c1", "C", null, 1, null});
    }

    private void createDepartmentEmployeesDataSet() throws Exception {
        this.tDepartment.insert(new Object[]{1, "Accounting"});
        this.tPerson.insert(new Object[]{7, "John", "EE", 25000, null, 1});
        this.tPerson.insert(new Object[]{8, "Susan", "EE", 50000, null, 1});
        this.tPerson.insert(new Object[]{9, "Kelly", "EM", 100000, null, 1});
    }

    @Test
    public void testMatchingOnSuperAttributes() throws Exception {
        this.create2PersonDataSet();
        SelectQuery<Manager> select = new SelectQuery<Manager>(Manager.class);
        select.andQualifier(ExpressionFactory.matchExp("name", "E2"));
        List results = this.context.performQuery(select);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)"E2", (Object)((Manager)results.get(0)).getName());
    }

    @Test
    public void testMatchingOnSuperAttributesWithPrefetch() throws Exception {
        this.create2PersonDataSet();
        SelectQuery<Employee> select = new SelectQuery<Employee>(Employee.class);
        select.addPrefetch("toDepartment");
        select.andQualifier(ExpressionFactory.matchExp("name", "E2"));
        List results = this.context.performQuery(select);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)"E2", (Object)((Manager)results.get(0)).getName());
    }

    @Test
    public void testPaginatedQueries() throws Exception {
        this.create5PersonDataSet();
        SelectQuery<AbstractPerson> select = new SelectQuery<AbstractPerson>(AbstractPerson.class);
        select.addOrdering("db:PERSON_ID", SortOrder.ASCENDING);
        select.setPageSize(3);
        List results = this.context.performQuery(select);
        Assert.assertEquals((long)5L, (long)results.size());
        Assert.assertTrue((boolean)(results.get(0) instanceof Employee));
        Assert.assertTrue((boolean)(results.get(1) instanceof Manager));
        Assert.assertTrue((boolean)(results.get(3) instanceof Manager));
        Assert.assertTrue((boolean)(results.get(4) instanceof Employee));
    }

    @Test
    public void testRelationshipToAbstractSuper() {
        this.context.performGenericQuery(new SQLTemplate(AbstractPerson.class, "INSERT INTO PERSON (PERSON_ID, NAME, PERSON_TYPE) VALUES (1, 'AA', 'EE')"));
        this.context.performGenericQuery(new SQLTemplate(PersonNotes.class, "INSERT INTO PERSON_NOTES (ID, NOTES, PERSON_ID) VALUES (1, 'AA', 1)"));
        PersonNotes note = Cayenne.objectForPK((ObjectContext)this.context, PersonNotes.class, 1);
        Assert.assertNotNull((Object)note);
        Assert.assertNotNull((Object)note.getPerson());
        Assert.assertTrue((boolean)(note.getPerson() instanceof Employee));
    }

    @Test
    public void testRelationshipAbstractFromSuperPrefetchingJoint() {
        this.context.performGenericQuery(new SQLTemplate(AbstractPerson.class, "INSERT INTO PERSON (PERSON_ID, NAME, PERSON_TYPE) VALUES (3, 'AA', 'EE')"));
        this.context.performGenericQuery(new SQLTemplate(PersonNotes.class, "INSERT INTO PERSON_NOTES (ID, NOTES, PERSON_ID) VALUES (3, 'AA', 3)"));
        this.context.performGenericQuery(new SQLTemplate(PersonNotes.class, "INSERT INTO PERSON_NOTES (ID, NOTES, PERSON_ID) VALUES (4, 'BB', 3)"));
        SelectQuery<AbstractPerson> query = new SelectQuery<AbstractPerson>(AbstractPerson.class);
        query.addPrefetch("notes").setSemantics(1);
        final AbstractPerson person = (AbstractPerson)Cayenne.objectForQuery(this.context, query);
        Assert.assertTrue((boolean)(person instanceof Employee));
        this.queryBlocker.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertEquals((long)2L, (long)person.getNotes().size());
                String[] names = new String[]{person.getNotes().get(0).getNotes(), person.getNotes().get(1).getNotes()};
                List<String> nameSet = Arrays.asList(names);
                Assert.assertTrue((boolean)nameSet.contains("AA"));
                Assert.assertTrue((boolean)nameSet.contains("BB"));
            }
        });
    }

    @Test
    public void testRelationshipAbstractFromSuperPrefetchingDisjoint() {
        this.context.performGenericQuery(new SQLTemplate(AbstractPerson.class, "INSERT INTO PERSON (PERSON_ID, NAME, PERSON_TYPE) VALUES (3, 'AA', 'EE')"));
        this.context.performGenericQuery(new SQLTemplate(PersonNotes.class, "INSERT INTO PERSON_NOTES (ID, NOTES, PERSON_ID) VALUES (3, 'AA', 3)"));
        this.context.performGenericQuery(new SQLTemplate(PersonNotes.class, "INSERT INTO PERSON_NOTES (ID, NOTES, PERSON_ID) VALUES (4, 'BB', 3)"));
        SelectQuery<AbstractPerson> query = new SelectQuery<AbstractPerson>(AbstractPerson.class);
        query.addPrefetch("notes");
        final AbstractPerson person = (AbstractPerson)Cayenne.objectForQuery(this.context, query);
        Assert.assertTrue((boolean)(person instanceof Employee));
        this.queryBlocker.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertEquals((long)2L, (long)person.getNotes().size());
                String[] names = new String[]{person.getNotes().get(0).getNotes(), person.getNotes().get(1).getNotes()};
                List<String> nameSet = Arrays.asList(names);
                Assert.assertTrue((boolean)nameSet.contains("AA"));
                Assert.assertTrue((boolean)nameSet.contains("BB"));
            }
        });
    }

    @Test
    public void testRelationshipAbstractToSuperPrefetchingDisjoint() {
        this.context.performGenericQuery(new SQLTemplate(AbstractPerson.class, "INSERT INTO PERSON (PERSON_ID, NAME, PERSON_TYPE) VALUES (2, 'AA', 'EE')"));
        this.context.performGenericQuery(new SQLTemplate(PersonNotes.class, "INSERT INTO PERSON_NOTES (ID, NOTES, PERSON_ID) VALUES (2, 'AA', 2)"));
        this.context.performGenericQuery(new SQLTemplate(PersonNotes.class, "INSERT INTO PERSON_NOTES (ID, NOTES, PERSON_ID) VALUES (3, 'BB', 2)"));
        SelectQuery<PersonNotes> query = new SelectQuery<PersonNotes>(PersonNotes.class);
        query.addPrefetch("person");
        query.addOrdering("notes", SortOrder.ASCENDING);
        List notes = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)notes.size());
        final PersonNotes note = (PersonNotes)notes.get(0);
        this.queryBlocker.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertEquals((Object)"AA", (Object)note.getPerson().getName());
            }
        });
    }

    @Test
    public void testRelationshipAbstractToSuperPrefetchingJoint() {
        this.context.performGenericQuery(new SQLTemplate(AbstractPerson.class, "INSERT INTO PERSON (PERSON_ID, NAME, PERSON_TYPE) VALUES (3, 'AA', 'EE')"));
        this.context.performGenericQuery(new SQLTemplate(PersonNotes.class, "INSERT INTO PERSON_NOTES (ID, NOTES, PERSON_ID) VALUES (3, 'AA', 3)"));
        SelectQuery<PersonNotes> query = new SelectQuery<PersonNotes>(PersonNotes.class);
        query.addPrefetch("person").setSemantics(1);
        final PersonNotes note = (PersonNotes)Cayenne.objectForQuery(this.context, query);
        this.queryBlocker.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertEquals((Object)"AA", (Object)note.getPerson().getName());
            }
        });
    }

    @Test
    public void testSave() throws Exception {
        ClientCompany company = this.context.newObject(ClientCompany.class);
        company.setName("Boeing");
        CustomerRepresentative rep = this.context.newObject(CustomerRepresentative.class);
        rep.setName("Joe Schmoe");
        rep.setToClientCompany(company);
        rep.setPersonType("C");
        Employee employee = this.context.newObject(Employee.class);
        employee.setName("Our Joe Schmoe");
        employee.setPersonType("E");
        this.context.commitChanges();
        this.context.invalidateObjects(company, rep, employee);
        SelectQuery<CustomerRepresentative> query = new SelectQuery<CustomerRepresentative>(CustomerRepresentative.class);
        List reps = this.context2.performQuery(query);
        Assert.assertEquals((long)1L, (long)reps.size());
        Assert.assertEquals((long)1L, (long)this.countObjectOfClass(reps, CustomerRepresentative.class));
    }

    @Test
    public void testEmployeeAddress() throws Exception {
        this.createEmployeeAddressDataSet();
        List addresses = this.context.performQuery(new SelectQuery<Address>(Address.class));
        Assert.assertEquals((long)1L, (long)addresses.size());
        Address address = (Address)addresses.get(0);
        Assert.assertSame(Employee.class, address.getToEmployee().getClass());
    }

    @Test
    public void testManagerAddress() throws Exception {
        this.createManagerAddressDataSet();
        List addresses = this.context.performQuery(new SelectQuery<Address>(Address.class));
        Assert.assertEquals((long)1L, (long)addresses.size());
        Address address = (Address)addresses.get(0);
        Employee e = address.getToEmployee();
        Assert.assertSame(Manager.class, e.getClass());
    }

    @Test
    public void testCAY592() throws Exception {
        this.createManagerAddressDataSet();
        List addresses = this.context.performQuery(new SelectQuery<Address>(Address.class));
        Assert.assertEquals((long)1L, (long)addresses.size());
        Address address = (Address)addresses.get(0);
        Employee e = address.getToEmployee();
        e = (Employee)Cayenne.objectForPK(this.context2, e.getObjectId());
        address = e.getAddresses().get(0);
        Assert.assertSame((Object)e, (Object)address.getToEmployee());
        address.setCity("XYZ");
        Assert.assertSame((Object)e, (Object)address.getToEmployee());
    }

    @Test
    public void testRepCompany() throws Exception {
        this.createRepCompanyDataSet();
        List companies = this.context.performQuery(new SelectQuery<ClientCompany>(ClientCompany.class));
        Assert.assertEquals((long)1L, (long)companies.size());
        ClientCompany company = (ClientCompany)companies.get(0);
        List<CustomerRepresentative> reps = company.getRepresentatives();
        Assert.assertEquals((long)1L, (long)reps.size());
        Assert.assertSame(CustomerRepresentative.class, reps.get(0).getClass());
    }

    @Test
    public void testDepartmentEmployees() throws Exception {
        this.createDepartmentEmployeesDataSet();
        List departments = this.context.performQuery(new SelectQuery<Department>(Department.class));
        Assert.assertEquals((long)1L, (long)departments.size());
        Department dept = (Department)departments.get(0);
        List<Employee> employees = dept.getEmployees();
        Assert.assertEquals((long)3L, (long)employees.size());
        Assert.assertEquals((long)3L, (long)this.countObjectOfClass(employees, Employee.class));
        Assert.assertEquals((long)1L, (long)this.countObjectOfClass(employees, Manager.class));
    }

    @Test
    public void testSelectInheritanceResolving() throws Exception {
        this.createSelectDataSet();
        SelectQuery<AbstractPerson> query = new SelectQuery<AbstractPerson>(AbstractPerson.class);
        List abstractPpl = this.context.performQuery(query);
        Assert.assertEquals((long)6L, (long)abstractPpl.size());
        Assert.assertEquals((long)1L, (long)this.countObjectOfClass(abstractPpl, CustomerRepresentative.class));
        Assert.assertEquals((long)5L, (long)this.countObjectOfClass(abstractPpl, Employee.class));
        Assert.assertEquals((long)2L, (long)this.countObjectOfClass(abstractPpl, Manager.class));
    }

    private int countObjectOfClass(List<?> objects, Class<?> aClass) {
        int i = 0;
        for (Object next : objects) {
            if (!aClass.isAssignableFrom(next.getClass())) continue;
            ++i;
        }
        return i;
    }
}

