/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.parallel.ParallelTestContainer;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ObjectStoreGCIT
extends ServerCase {
    @Inject
    private DataContext context;

    @Test
    public void testReleaseUnreferenced() throws Exception {
        this.context.performGenericQuery(new SQLTemplate(Artist.class, "insert into ARTIST (ARTIST_ID, ARTIST_NAME) values (1, 'aa')"));
        Assert.assertEquals((long)0L, (long)this.context.getObjectStore().registeredObjectsCount());
        this.context.performQuery(new SelectQuery<Artist>(Artist.class));
        Assert.assertEquals((long)1L, (long)this.context.getObjectStore().registeredObjectsCount());
        new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                System.gc();
                Assert.assertEquals((long)0L, (long)ObjectStoreGCIT.this.context.getObjectStore().registeredObjectsCount());
            }
        }.runTest(2000L);
    }

    @Test
    public void testRetainUnreferencedNew() throws Exception {
        Assert.assertEquals((long)0L, (long)this.context.getObjectStore().registeredObjectsCount());
        Artist a = this.context.newObject(Artist.class);
        a.setArtistName("X");
        a = null;
        Assert.assertEquals((long)1L, (long)this.context.getObjectStore().registeredObjectsCount());
        new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                System.gc();
                Assert.assertEquals((long)1L, (long)ObjectStoreGCIT.this.context.getObjectStore().registeredObjectsCount());
            }
        }.runTest(2000L);
        Assert.assertEquals((long)1L, (long)this.context.getObjectStore().registeredObjectsCount());
        this.context.commitChanges();
        new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                System.gc();
                Assert.assertEquals((long)0L, (long)ObjectStoreGCIT.this.context.getObjectStore().registeredObjectsCount());
            }
        }.runTest(2000L);
    }

    @Test
    public void testRetainUnreferencedModified() throws Exception {
        this.context.performGenericQuery(new SQLTemplate(Artist.class, "insert into ARTIST (ARTIST_ID, ARTIST_NAME) values (1, 'aa')"));
        Assert.assertEquals((long)0L, (long)this.context.getObjectStore().registeredObjectsCount());
        Artist a = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 1);
        a.setArtistName("Y");
        a = null;
        Assert.assertEquals((long)1L, (long)this.context.getObjectStore().registeredObjectsCount());
        new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                System.gc();
                Assert.assertEquals((long)1L, (long)ObjectStoreGCIT.this.context.getObjectStore().registeredObjectsCount());
            }
        }.runTest(2000L);
        this.context.commitChanges();
        new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                System.gc();
                Assert.assertEquals((long)0L, (long)ObjectStoreGCIT.this.context.getObjectStore().registeredObjectsCount());
            }
        }.runTest(2000L);
    }
}

