/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.generated.GeneratedColumnCompKey;
import org.apache.cayenne.testdo.generated.GeneratedColumnCompMaster;
import org.apache.cayenne.testdo.generated.GeneratedColumnDep;
import org.apache.cayenne.testdo.generated.GeneratedColumnTest2;
import org.apache.cayenne.testdo.generated.GeneratedColumnTestEntity;
import org.apache.cayenne.testdo.generated.GeneratedF1;
import org.apache.cayenne.testdo.generated.GeneratedF2;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-generated.xml")
public class IdentityColumnsIT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    @Inject
    protected DbAdapter adapter;
    @Inject
    protected DataNode node;
    protected TableHelper joinTable;

    @Before
    public void setUp() throws Exception {
        this.joinTable = new TableHelper(this.dbHelper, "GENERATED_JOIN");
    }

    @Test
    public void testCAY823() throws Exception {
        GeneratedColumnTestEntity idObject = this.context.newObject(GeneratedColumnTestEntity.class);
        String name = "n_" + System.currentTimeMillis();
        idObject.setName(name);
        idObject.getObjectContext().commitChanges();
        ObjectId id = idObject.getObjectId();
        this.context.invalidateObjects(idObject);
        SelectQuery<GeneratedColumnTestEntity> q = new SelectQuery<GeneratedColumnTestEntity>(GeneratedColumnTestEntity.class);
        q.setPageSize(10);
        List results = this.context.performQuery(q);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)id, (Object)((Persistent)results.get(0)).getObjectId());
    }

    @Test
    public void testNewObject() throws Exception {
        GeneratedColumnTestEntity idObject = this.context.newObject(GeneratedColumnTestEntity.class);
        String name = "n_" + System.currentTimeMillis();
        idObject.setName(name);
        idObject.getObjectContext().commitChanges();
        int id = Cayenne.intPKForObject(idObject);
        Assert.assertTrue((id >= 0 ? 1 : 0) != 0);
        this.context.invalidateObjects(idObject);
        GeneratedColumnTestEntity object = Cayenne.objectForPK(this.context, GeneratedColumnTestEntity.class, id);
        Assert.assertNotNull((Object)object);
        Assert.assertEquals((Object)name, (Object)object.getName());
    }

    @Test
    public void testGeneratedJoinInFlattenedRelationship() throws Exception {
        DbEntity joinTableEntity = this.context.getEntityResolver().getDbEntity(this.joinTable.getTableName());
        DbAttribute pkAttribute = joinTableEntity.getAttribute("ID");
        Number pk = (Number)this.adapter.getPkGenerator().generatePk(this.node, pkAttribute);
        GeneratedF1 f1 = this.context.newObject(GeneratedF1.class);
        GeneratedF2 f2 = this.context.newObject(GeneratedF2.class);
        f1.addToF2(f2);
        this.context.commitChanges();
        int id = this.joinTable.getInt("ID");
        Assert.assertTrue((id > 0 ? 1 : 0) != 0);
        if (this.adapter.supportsGeneratedKeys()) {
            Assert.assertFalse((String)("Looks like auto-increment wasn't used for the join table. ID: " + id), (id == pk.intValue() + 1 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((long)id, (long)(pk.intValue() + 1));
        }
    }

    @Test
    public void testUnrelatedUpdate() throws Exception {
        GeneratedColumnTestEntity m = this.context.newObject(GeneratedColumnTestEntity.class);
        m.setName("m");
        GeneratedColumnDep d = this.context.newObject(GeneratedColumnDep.class);
        d.setName("d");
        d.setToMaster(m);
        this.context.commitChanges();
        this.context.invalidateObjects(m, d);
        this.context.prepareForAccess(d, null, false);
        d.getToMaster();
        d.setName("new name");
        this.context.commitChanges();
    }

    @Test
    public void testMultipleNewObjectsSeparateTables() throws Exception {
        GeneratedColumnTestEntity idObject1 = this.context.newObject(GeneratedColumnTestEntity.class);
        idObject1.setName("o1");
        GeneratedColumnTest2 idObject2 = this.context.newObject(GeneratedColumnTest2.class);
        idObject2.setName("o2");
        this.context.commitChanges();
    }

    @Test
    public void testMultipleNewObjects() throws Exception {
        int i;
        String[] names = new String[]{"n1_" + System.currentTimeMillis(), "n2_" + System.currentTimeMillis(), "n3_" + System.currentTimeMillis()};
        GeneratedColumnTestEntity[] idObjects = new GeneratedColumnTestEntity[]{this.context.newObject(GeneratedColumnTestEntity.class), this.context.newObject(GeneratedColumnTestEntity.class), this.context.newObject(GeneratedColumnTestEntity.class)};
        for (int i2 = 0; i2 < idObjects.length; ++i2) {
            idObjects[i2].setName(names[i2]);
        }
        this.context.commitChanges();
        int[] ids = new int[idObjects.length];
        for (i = 0; i < idObjects.length; ++i) {
            ids[i] = Cayenne.intPKForObject(idObjects[i]);
            Assert.assertTrue((ids[i] > 0 ? 1 : 0) != 0);
        }
        this.context.invalidateObjects(idObjects);
        for (i = 0; i < ids.length; ++i) {
            GeneratedColumnTestEntity object = Cayenne.objectForPK(this.context, GeneratedColumnTestEntity.class, ids[i]);
            Assert.assertNotNull((Object)object);
            Assert.assertEquals((Object)names[i], (Object)object.getName());
        }
    }

    @Test
    public void testCompoundPKWithGeneratedColumn() throws Exception {
        if (this.adapter.supportsGeneratedKeys()) {
            String masterName = "m_" + System.currentTimeMillis();
            String depName1 = "dep1_" + System.currentTimeMillis();
            String depName2 = "dep2_" + System.currentTimeMillis();
            GeneratedColumnCompMaster master = this.context.newObject(GeneratedColumnCompMaster.class);
            master.setName(masterName);
            GeneratedColumnCompKey dep1 = this.context.newObject(GeneratedColumnCompKey.class);
            dep1.setName(depName1);
            dep1.setToMaster(master);
            GeneratedColumnCompKey dep2 = this.context.newObject(GeneratedColumnCompKey.class);
            dep2.setName(depName2);
            dep2.setToMaster(master);
            this.context.commitChanges();
            int masterId = Cayenne.intPKForObject(master);
            ObjectId id2 = dep2.getObjectId();
            Number propagatedID2 = (Number)id2.getIdSnapshot().get("PROPAGATED_PK");
            Assert.assertNotNull((Object)propagatedID2);
            Assert.assertEquals((long)masterId, (long)propagatedID2.intValue());
            Number cayenneGeneratedID2 = (Number)id2.getIdSnapshot().get("AUTO_PK");
            Assert.assertNotNull((Object)cayenneGeneratedID2);
            Number dbGeneratedID2 = (Number)id2.getIdSnapshot().get("GENERATED_COLUMN");
            Assert.assertNotNull((Object)dbGeneratedID2);
            this.context.invalidateObjects(master, dep1, dep2);
            Object fetchedDep2 = Cayenne.objectForPK(this.context, id2);
            Assert.assertNotNull((Object)fetchedDep2);
        }
    }

    @Test
    public void testUpdateDependentWithNewMaster() throws Exception {
        GeneratedColumnTestEntity master1 = this.context.newObject(GeneratedColumnTestEntity.class);
        master1.setName("aaa");
        GeneratedColumnDep dependent = this.context.newObject(GeneratedColumnDep.class);
        dependent.setName("aaa");
        dependent.setToMaster(master1);
        this.context.commitChanges();
        GeneratedColumnTestEntity master2 = this.context.newObject(GeneratedColumnTestEntity.class);
        master2.setName("bbb");
        dependent.setToMaster(master2);
        this.context.commitChanges();
        int id1 = Cayenne.intPKForObject(master2);
        Assert.assertTrue((id1 >= 0 ? 1 : 0) != 0);
        int id2 = Cayenne.intPKForObject(dependent);
        Assert.assertTrue((id2 >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)id1, (long)id2);
        this.context.invalidateObjects(master2, dependent);
        Assert.assertNotNull((Object)Cayenne.objectForPK(this.context, GeneratedColumnTestEntity.class, id1));
        Assert.assertNotNull((Object)Cayenne.objectForPK(this.context, GeneratedColumnDep.class, id2));
    }

    @Test
    public void testGeneratedDefaultValue() throws Exception {
    }

    @Test
    public void testPropagateToDependent() throws Exception {
        GeneratedColumnTestEntity idObject = this.context.newObject(GeneratedColumnTestEntity.class);
        idObject.setName("aaa");
        GeneratedColumnDep dependent = idObject.getObjectContext().newObject(GeneratedColumnDep.class);
        dependent.setName("aaa");
        dependent.setToMaster(idObject);
        this.context.commitChanges();
        int id1 = Cayenne.intPKForObject(idObject);
        Assert.assertTrue((id1 >= 0 ? 1 : 0) != 0);
        int id2 = Cayenne.intPKForObject(dependent);
        Assert.assertTrue((id2 >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)id1, (long)id2);
        this.context.invalidateObjects(idObject, dependent);
        Assert.assertNotNull((Object)Cayenne.objectForPK(this.context, GeneratedColumnTestEntity.class, id1));
        Assert.assertNotNull((Object)Cayenne.objectForPK(this.context, GeneratedColumnDep.class, id2));
    }
}

