/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import org.apache.cayenne.DeleteDenyException;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.ObjectDiff;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.graph.NodeDiff;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.testdo.relationships_delete_rules.DeleteRuleFlatA;
import org.apache.cayenne.testdo.relationships_delete_rules.DeleteRuleFlatB;
import org.apache.cayenne.testdo.relationships_delete_rules.DeleteRuleTest1;
import org.apache.cayenne.testdo.relationships_delete_rules.DeleteRuleTest2;
import org.apache.cayenne.testdo.relationships_delete_rules.DeleteRuleTest3;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-relationships-delete-rules.xml")
public class DeleteRulesIT
extends ServerCase {
    @Inject
    private DataContext context;

    @Test
    public void testDenyToOne() {
        DeleteRuleTest1 test1 = this.context.newObject(DeleteRuleTest1.class);
        DeleteRuleTest2 test2 = this.context.newObject(DeleteRuleTest2.class);
        test1.setTest2(test2);
        this.context.commitChanges();
        try {
            this.context.deleteObjects(test1);
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.context.commitChanges();
    }

    @Test
    public void testNoActionToOne() {
        DeleteRuleTest2 test2 = this.context.newObject(DeleteRuleTest2.class);
        DeleteRuleTest3 test3 = this.context.newObject(DeleteRuleTest3.class);
        test3.setToDeleteRuleTest2(test2);
        this.context.commitChanges();
        this.context.deleteObjects(test3);
        this.context.commitChanges();
    }

    @Test
    public void testNoActionToMany() {
        DeleteRuleTest2 test2 = this.context.newObject(DeleteRuleTest2.class);
        DeleteRuleTest3 test3 = this.context.newObject(DeleteRuleTest3.class);
        test3.setToDeleteRuleTest2(test2);
        this.context.commitChanges();
        this.context.deleteObjects(test2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoActionFlattened() {
        int oldRule = this.changeDeleteRule(0);
        try {
            DeleteRuleFlatA a = this.context.newObject(DeleteRuleFlatA.class);
            DeleteRuleFlatB b = this.context.newObject(DeleteRuleFlatB.class);
            a.addToFlatB(b);
            this.context.commitChanges();
            this.context.deleteObjects(a);
            this.assertJoinDeleted(a, b);
            Assert.assertEquals((long)6L, (long)a.getPersistenceState());
            Assert.assertEquals((long)3L, (long)b.getPersistenceState());
            Assert.assertTrue((boolean)b.getUntitledRel().contains(a));
            this.context.commitChanges();
        }
        finally {
            this.changeDeleteRule(oldRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoActionFlattenedNoReverse() {
        int oldRule = this.changeDeleteRule(0);
        ObjRelationship reverse = this.unsetReverse();
        try {
            DeleteRuleFlatA a = this.context.newObject(DeleteRuleFlatA.class);
            DeleteRuleFlatB b = this.context.newObject(DeleteRuleFlatB.class);
            a.addToFlatB(b);
            this.context.commitChanges();
            this.context.deleteObjects(a);
            this.assertJoinDeleted(a, b);
            Assert.assertEquals((long)6L, (long)a.getPersistenceState());
            Assert.assertEquals((long)3L, (long)b.getPersistenceState());
            this.context.commitChanges();
        }
        finally {
            this.changeDeleteRule(oldRule);
            this.restoreReverse(reverse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCascadeFlattened() {
        int oldRule = this.changeDeleteRule(2);
        try {
            DeleteRuleFlatA a = this.context.newObject(DeleteRuleFlatA.class);
            DeleteRuleFlatB b = this.context.newObject(DeleteRuleFlatB.class);
            a.addToFlatB(b);
            this.context.commitChanges();
            this.context.deleteObjects(a);
            this.assertJoinDeleted(a, b);
            this.context.commitChanges();
            Assert.assertEquals((long)1L, (long)a.getPersistenceState());
            Assert.assertEquals((long)1L, (long)b.getPersistenceState());
        }
        finally {
            this.changeDeleteRule(oldRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCascadeFlattenedNoReverse() {
        int oldRule = this.changeDeleteRule(2);
        ObjRelationship reverse = this.unsetReverse();
        try {
            DeleteRuleFlatA a = this.context.newObject(DeleteRuleFlatA.class);
            DeleteRuleFlatB b = this.context.newObject(DeleteRuleFlatB.class);
            a.addToFlatB(b);
            this.context.commitChanges();
            this.context.deleteObjects(a);
            this.assertJoinDeleted(a, b);
            this.context.commitChanges();
            Assert.assertEquals((long)1L, (long)a.getPersistenceState());
            Assert.assertEquals((long)1L, (long)b.getPersistenceState());
        }
        finally {
            this.changeDeleteRule(oldRule);
            this.restoreReverse(reverse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullifyFlattened() {
        int oldRule = this.changeDeleteRule(1);
        try {
            DeleteRuleFlatA a = this.context.newObject(DeleteRuleFlatA.class);
            DeleteRuleFlatB b = this.context.newObject(DeleteRuleFlatB.class);
            a.addToFlatB(b);
            this.context.commitChanges();
            this.context.deleteObjects(a);
            this.assertJoinDeleted(a, b);
            Assert.assertEquals((long)6L, (long)a.getPersistenceState());
            Assert.assertEquals((long)4L, (long)b.getPersistenceState());
            Assert.assertFalse((boolean)b.getUntitledRel().contains(a));
            this.context.commitChanges();
        }
        finally {
            this.changeDeleteRule(oldRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullifyFlattenedNoReverse() {
        int oldRule = this.changeDeleteRule(1);
        ObjRelationship reverse = this.unsetReverse();
        try {
            DeleteRuleFlatA a = this.context.newObject(DeleteRuleFlatA.class);
            DeleteRuleFlatB b = this.context.newObject(DeleteRuleFlatB.class);
            a.addToFlatB(b);
            this.context.commitChanges();
            this.context.deleteObjects(a);
            this.assertJoinDeleted(a, b);
            Assert.assertEquals((long)6L, (long)a.getPersistenceState());
            Assert.assertEquals((long)3L, (long)b.getPersistenceState());
            this.context.commitChanges();
        }
        finally {
            this.changeDeleteRule(oldRule);
            this.restoreReverse(reverse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDenyFlattened() {
        int oldRule = this.changeDeleteRule(3);
        try {
            DeleteRuleFlatA a = this.context.newObject(DeleteRuleFlatA.class);
            DeleteRuleFlatB b = this.context.newObject(DeleteRuleFlatB.class);
            a.addToFlatB(b);
            this.context.commitChanges();
            try {
                this.context.deleteObjects(a);
                Assert.fail((String)"Must have thrown a deny exception..");
            }
            catch (DeleteDenyException ex) {
                this.assertJoinNotDeleted(a, b);
            }
        }
        finally {
            this.changeDeleteRule(oldRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDenyFlattenedNoReverse() {
        int oldRule = this.changeDeleteRule(3);
        ObjRelationship reverse = this.unsetReverse();
        try {
            DeleteRuleFlatA a = this.context.newObject(DeleteRuleFlatA.class);
            DeleteRuleFlatB b = this.context.newObject(DeleteRuleFlatB.class);
            a.addToFlatB(b);
            this.context.commitChanges();
            try {
                this.context.deleteObjects(a);
                Assert.fail((String)"Must have thrown a deny exception..");
            }
            catch (DeleteDenyException ex) {
                this.assertJoinNotDeleted(a, b);
            }
        }
        finally {
            this.changeDeleteRule(oldRule);
            this.restoreReverse(reverse);
        }
    }

    private int changeDeleteRule(int deleteRule) {
        ObjEntity entity = this.context.getEntityResolver().getObjEntity(DeleteRuleFlatA.class);
        ObjRelationship relationship = entity.getRelationship("flatB");
        int oldRule = relationship.getDeleteRule();
        relationship.setDeleteRule(deleteRule);
        return oldRule;
    }

    private ObjRelationship unsetReverse() {
        ObjEntity entity = this.context.getEntityResolver().getObjEntity(DeleteRuleFlatA.class);
        ObjRelationship relationship = entity.getRelationship("flatB");
        ObjRelationship reverse = relationship.getReverseRelationship();
        if (reverse != null) {
            reverse.getSourceEntity().removeRelationship(reverse.getName());
            this.context.getEntityResolver().getClassDescriptorMap().removeDescriptor("DeleteRuleFlatA");
            this.context.getEntityResolver().getClassDescriptorMap().removeDescriptor("DeleteRuleFlatB");
        }
        return reverse;
    }

    private void restoreReverse(ObjRelationship reverse) {
        ObjEntity entity = this.context.getEntityResolver().getObjEntity(DeleteRuleFlatA.class);
        ObjRelationship relationship = entity.getRelationship("flatB");
        relationship.getTargetEntity().addRelationship(reverse);
        this.context.getEntityResolver().getClassDescriptorMap().removeDescriptor("DeleteRuleFlatA");
        this.context.getEntityResolver().getClassDescriptorMap().removeDescriptor("DeleteRuleFlatB");
    }

    private void assertJoinDeleted(DeleteRuleFlatA a, DeleteRuleFlatB b) {
        ObjectDiff changes = this.context.getObjectStore().changes.get(a.getObjectId());
        Assert.assertNotNull((Object)changes);
        ArrayList<NodeDiff> diffs = new ArrayList<NodeDiff>();
        changes.appendDiffs(diffs);
        for (Object e : diffs) {
            ObjectDiff.ArcOperation arcDelete;
            if (!(e instanceof ObjectDiff.ArcOperation) || !(arcDelete = (ObjectDiff.ArcOperation)e).getNodeId().equals(a.getObjectId()) || !arcDelete.getTargetNodeId().equals(b.getObjectId()) || !arcDelete.getArcId().equals("flatB") || !arcDelete.isDelete()) continue;
            return;
        }
        Assert.fail((String)"Join was not deleted for flattened relationship");
    }

    private void assertJoinNotDeleted(DeleteRuleFlatA a, DeleteRuleFlatB b) {
        ObjectDiff changes = this.context.getObjectStore().changes.get(a.getObjectId());
        if (changes != null) {
            ArrayList<NodeDiff> diffs = new ArrayList<NodeDiff>();
            changes.appendDiffs(diffs);
            for (Object e : diffs) {
                ObjectDiff.ArcOperation arcDelete;
                if (!(e instanceof ObjectDiff.ArcOperation) || !(arcDelete = (ObjectDiff.ArcOperation)e).getNodeId().equals(a.getObjectId()) || !arcDelete.getTargetNodeId().equals(b.getObjectId()) || !arcDelete.getArcId().equals("flatB") || arcDelete.isDelete()) continue;
                Assert.fail((String)"Join was  deleted for flattened relationship");
            }
        }
    }
}

