/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collection;
import org.apache.cayenne.access.DbLoader;
import org.apache.cayenne.access.loader.DefaultDbLoaderDelegate;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.ServerCaseDataSourceFactory;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DbLoaderPartialIT
extends ServerCase {
    @Inject
    private DbAdapter adapter;
    @Inject
    private ServerCaseDataSourceFactory dataSourceFactory;
    private DbLoader loader;

    @Before
    public void setUp() throws Exception {
        this.loader = new DbLoader(this.dataSourceFactory.getSharedDataSource().getConnection(), this.adapter, new DefaultDbLoaderDelegate());
    }

    @After
    public void tearDown() throws Exception {
        this.loader.getConnection().close();
    }

    @Test
    public void testPartialLoad() throws Exception {
        DataMap map = new DataMap();
        String tableLabel = this.adapter.tableTypeForTable();
        this.loader.loadDataMapFromDB(null, "%", new String[]{tableLabel}, map);
        Collection<DbRelationship> rels = this.getDbEntity(map, "ARTIST").getRelationships();
        Assert.assertNotNull(rels);
        int artistRels = rels.size();
        rels = this.getDbEntity(map, "GALLERY").getRelationships();
        Assert.assertNotNull(rels);
        int galleryRels = rels.size();
        rels = this.getDbEntity(map, "PAINTING").getRelationships();
        Assert.assertNotNull(rels);
        int paintingRels = rels.size();
        this.loader.loadDataMapFromDB(null, "%", new String[]{tableLabel}, map);
        rels = this.getDbEntity(map, "ARTIST").getRelationships();
        Assert.assertNotNull(rels);
        Assert.assertEquals((long)artistRels, (long)rels.size());
        rels = this.getDbEntity(map, "GALLERY").getRelationships();
        Assert.assertNotNull(rels);
        Assert.assertEquals((long)galleryRels, (long)rels.size());
        rels = this.getDbEntity(map, "PAINTING").getRelationships();
        Assert.assertNotNull(rels);
        Assert.assertEquals((long)paintingRels, (long)rels.size());
    }

    private DbEntity getDbEntity(DataMap map, String name) {
        DbEntity de = map.getDbEntity(name);
        if (de == null) {
            de = map.getDbEntity(name.toLowerCase());
        }
        return de;
    }
}

