/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.HashMap;
import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.configuration.CayenneRuntime;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.util.Util;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextSerializationIT
extends ServerCase {
    @Inject
    protected DataContext context;
    @Inject
    protected ServerRuntime runtime;
    @Inject
    protected DBHelper dbHelper;
    @Inject
    protected JdbcEventLogger logger;
    protected TableHelper tArtist;

    @Before
    public void setUp() throws Exception {
        CayenneRuntime.bindThreadInjector(this.runtime.getInjector());
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
    }

    protected void createSingleArtistDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "aaa"});
    }

    @After
    public void tearDown() throws Exception {
        CayenneRuntime.bindThreadInjector(null);
    }

    @Test
    public void testSerializeResolver() throws Exception {
        DataContext deserializedContext = Util.cloneViaSerialization(this.context);
        Assert.assertNotNull((Object)deserializedContext.getEntityResolver());
        Assert.assertSame((Object)this.context.getEntityResolver(), (Object)deserializedContext.getEntityResolver());
    }

    @Test
    public void testSerializeChannel() throws Exception {
        DataContext deserializedContext = Util.cloneViaSerialization(this.context);
        Assert.assertNotNull((Object)deserializedContext.getChannel());
        Assert.assertSame((Object)this.context.getChannel(), (Object)deserializedContext.getChannel());
    }

    @Test
    public void testSerializeNestedChannel() throws Exception {
        ObjectContext child = this.runtime.newContext(this.context);
        ObjectContext deserializedContext = Util.cloneViaSerialization(child);
        Assert.assertNotNull((Object)deserializedContext.getChannel());
        Assert.assertNotNull((Object)deserializedContext.getEntityResolver());
    }

    @Test
    public void testSerializeWithSharedCache() throws Exception {
        this.createSingleArtistDataSet();
        DataContext deserializedContext = Util.cloneViaSerialization(this.context);
        Assert.assertNotSame((Object)this.context, (Object)deserializedContext);
        Assert.assertNotSame((Object)this.context.getObjectStore(), (Object)deserializedContext.getObjectStore());
        Assert.assertSame((Object)this.context.getParentDataDomain(), (Object)deserializedContext.getParentDataDomain());
        Assert.assertSame((Object)this.context.getObjectStore().getDataRowCache(), (Object)deserializedContext.getObjectStore().getDataRowCache());
        Assert.assertSame((Object)deserializedContext.getParentDataDomain().getSharedSnapshotCache(), (Object)deserializedContext.getObjectStore().getDataRowCache());
        Assert.assertNotNull((Object)deserializedContext.getEntityResolver());
        Assert.assertSame((Object)this.context.getEntityResolver(), (Object)deserializedContext.getEntityResolver());
        Artist a = Cayenne.objectForPK((ObjectContext)deserializedContext, Artist.class, 33001);
        Assert.assertNotNull((Object)a);
        a.setArtistName(a.getArtistName() + "___");
        deserializedContext.commitChanges();
    }

    @Test
    public void testSerializeWithLocalCache() throws Exception {
        this.createSingleArtistDataSet();
        DataDomain domain = this.context.getParentDataDomain();
        DataRowStore snapshotCache = new DataRowStore(domain.getName(), domain.getProperties(), domain.getEventManager());
        HashMap<Object, Persistent> map = new HashMap<Object, Persistent>();
        DataContext localCacheContext = new DataContext(domain, new ObjectStore(snapshotCache, map));
        localCacheContext.setValidatingObjectsOnCommit(domain.isValidatingObjectsOnCommit());
        localCacheContext.setUsingSharedSnapshotCache(false);
        Assert.assertNotSame((Object)domain.getSharedSnapshotCache(), (Object)localCacheContext.getObjectStore().getDataRowCache());
        DataContext deserializedContext = Util.cloneViaSerialization(localCacheContext);
        Assert.assertNotSame((Object)localCacheContext, (Object)deserializedContext);
        Assert.assertNotSame((Object)localCacheContext.getObjectStore(), (Object)deserializedContext.getObjectStore());
        Assert.assertSame((Object)localCacheContext.getParentDataDomain(), (Object)deserializedContext.getParentDataDomain());
        Assert.assertNotSame((Object)localCacheContext.getObjectStore().getDataRowCache(), (Object)deserializedContext.getObjectStore().getDataRowCache());
        Assert.assertNotSame((Object)deserializedContext.getParentDataDomain().getSharedSnapshotCache(), (Object)deserializedContext.getObjectStore().getDataRowCache());
        Artist a = Cayenne.objectForPK((ObjectContext)deserializedContext, Artist.class, 33001);
        Assert.assertNotNull((Object)a);
        a.setArtistName(a.getArtistName() + "___");
        deserializedContext.commitChanges();
    }

    @Test
    public void testSerializeNew() throws Exception {
        Artist artist = (Artist)this.context.newObject("Artist");
        artist.setArtistName("artist1");
        Assert.assertNotNull((Object)artist.getObjectId());
        DataContext deserializedContext = Util.cloneViaSerialization(this.context);
        Assert.assertSame((Object)this.context.getParentDataDomain(), (Object)deserializedContext.getParentDataDomain());
        Artist deserializedArtist = (Artist)deserializedContext.getObjectStore().getObjectIterator().next();
        Assert.assertNotNull((Object)deserializedArtist);
        Assert.assertEquals((long)2L, (long)deserializedArtist.getPersistenceState());
        Assert.assertTrue((boolean)deserializedArtist.getObjectId().isTemporary());
        Assert.assertEquals((Object)"artist1", (Object)deserializedArtist.getArtistName());
        Assert.assertSame((Object)deserializedContext, (Object)deserializedArtist.getObjectContext());
    }

    @Test
    public void testSerializeCommitted() throws Exception {
        Artist artist = (Artist)this.context.newObject("Artist");
        artist.setArtistName("artist1");
        Assert.assertNotNull((Object)artist.getObjectId());
        this.context.commitChanges();
        DataContext deserializedContext = Util.cloneViaSerialization(this.context);
        Assert.assertSame((Object)this.context.getParentDataDomain(), (Object)deserializedContext.getParentDataDomain());
        Artist deserializedArtist = (Artist)deserializedContext.getObjectStore().getObjectIterator().next();
        Assert.assertNotNull((Object)deserializedArtist);
        Assert.assertEquals((long)5L, (long)deserializedArtist.getPersistenceState());
        Assert.assertFalse((boolean)deserializedArtist.getObjectId().isTemporary());
        Assert.assertEquals((Object)"artist1", (Object)deserializedArtist.getArtistName());
        Assert.assertSame((Object)deserializedContext, (Object)deserializedArtist.getObjectContext());
        List<Painting> paintings = deserializedArtist.getPaintingArray();
        Assert.assertNotNull(paintings);
        Assert.assertEquals((long)0L, (long)paintings.size());
    }

    @Test
    public void testSerializeModified() throws Exception {
        Artist artist = (Artist)this.context.newObject("Artist");
        artist.setArtistName("artist1");
        Assert.assertNotNull((Object)artist.getObjectId());
        this.context.commitChanges();
        artist.setArtistName("artist2");
        DataContext deserializedContext = Util.cloneViaSerialization(this.context);
        Assert.assertSame((Object)this.context.getParentDataDomain(), (Object)deserializedContext.getParentDataDomain());
        Artist deserializedArtist = (Artist)deserializedContext.getObjectStore().getObjectIterator().next();
        Assert.assertNotNull((Object)deserializedArtist);
        Assert.assertEquals((long)4L, (long)deserializedArtist.getPersistenceState());
        Assert.assertFalse((boolean)deserializedArtist.getObjectId().isTemporary());
        Assert.assertEquals((Object)"artist2", (Object)deserializedArtist.getArtistName());
        Assert.assertSame((Object)deserializedContext, (Object)deserializedArtist.getObjectContext());
    }
}

