/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.CapsStrategy;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.compound.CompoundFkTestEntity;
import org.apache.cayenne.testdo.compound.CompoundPkTestEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-compound.xml")
public class DataContextSQLTemplateCompoundIT
extends ServerCase {
    @Inject
    protected DataContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tCompoundPkTest;
    protected TableHelper tCompoundFkTest;

    @Before
    public void setUp() throws Exception {
        this.tCompoundPkTest = new TableHelper(this.dbHelper, "COMPOUND_PK_TEST");
        this.tCompoundPkTest.setColumns(new String[]{"KEY1", "KEY2"});
        this.tCompoundFkTest = new TableHelper(this.dbHelper, "COMPOUND_FK_TEST");
        this.tCompoundFkTest.setColumns(new String[]{"PKEY", "F_KEY1", "F_KEY2"});
    }

    protected void createTwoCompoundPKsAndCompoundFKsDataSet() throws Exception {
        this.tCompoundPkTest.insert(new Object[]{"a1", "a2"});
        this.tCompoundPkTest.insert(new Object[]{"b1", "b2"});
        this.tCompoundFkTest.insert(new Object[]{6, "a1", "a2"});
        this.tCompoundFkTest.insert(new Object[]{7, "b1", "b2"});
    }

    @Test
    public void testBindObjectEqualCompound() throws Exception {
        this.createTwoCompoundPKsAndCompoundFKsDataSet();
        HashMap<String, String> pk = new HashMap<String, String>();
        pk.put("KEY1", "a1");
        pk.put("KEY2", "a2");
        CompoundPkTestEntity a = Cayenne.objectForPK((ObjectContext)this.context, CompoundPkTestEntity.class, pk);
        String template = "SELECT * FROM COMPOUND_FK_TEST t0 WHERE #bindObjectEqual($a [ 't0.F_KEY1', 't0.F_KEY2' ] [ 'KEY1', 'KEY2' ] ) ORDER BY PKEY";
        SQLTemplate query = new SQLTemplate(CompoundFkTestEntity.class, template);
        query.setColumnNamesCapitalization(CapsStrategy.UPPER);
        query.setParameters(Collections.singletonMap("a", a));
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        CompoundFkTestEntity p = (CompoundFkTestEntity)objects.get(0);
        Assert.assertEquals((long)6L, (long)Cayenne.intPKForObject(p));
    }

    @Test
    public void testBindObjectNotEqualCompound() throws Exception {
        this.createTwoCompoundPKsAndCompoundFKsDataSet();
        HashMap<String, String> pk = new HashMap<String, String>();
        pk.put("KEY1", "a1");
        pk.put("KEY2", "a2");
        CompoundPkTestEntity a = Cayenne.objectForPK((ObjectContext)this.context, CompoundPkTestEntity.class, pk);
        String template = "SELECT * FROM COMPOUND_FK_TEST t0 WHERE #bindObjectNotEqual($a [ 't0.F_KEY1', 't0.F_KEY2' ] [ 'KEY1', 'KEY2' ] ) ORDER BY PKEY";
        SQLTemplate query = new SQLTemplate(CompoundFkTestEntity.class, template);
        query.setColumnNamesCapitalization(CapsStrategy.UPPER);
        query.setParameters(Collections.singletonMap("a", a));
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        CompoundFkTestEntity p = (CompoundFkTestEntity)objects.get(0);
        Assert.assertEquals((long)7L, (long)Cayenne.intPKForObject(p));
    }
}

