/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collections;
import java.util.Date;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextObjectTrackingIT
extends ServerCase {
    @Inject
    protected DataChannelInterceptor queryInterceptor;
    @Inject
    protected DataContext context;
    @Inject
    protected DBHelper dbHelper;
    @Inject
    protected ServerRuntime runtime;
    protected TableHelper tArtist;
    protected TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "ARTIST_ID", "PAINTING_TITLE", "ESTIMATED_PRICE"}).setColumnTypes(new int[]{4, -5, 12, 3});
    }

    protected void createArtistsDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "artist1"});
        this.tArtist.insert(new Object[]{33002, "artist2"});
        this.tArtist.insert(new Object[]{33003, "artist3"});
        this.tArtist.insert(new Object[]{33004, "artist4"});
    }

    protected void createMixedDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33003, "artist3"});
        this.tPainting.insert(new Object[]{33003, 33003, "P_artist3", 3000});
    }

    @Test
    public void testUnregisterObject() {
        DataRow row = new DataRow(10);
        row.put("ARTIST_ID", new Integer(1));
        row.put("ARTIST_NAME", "ArtistXYZ");
        row.put("DATE_OF_BIRTH", new Date());
        DataObject obj = this.context.objectFromDataRow(Artist.class, row);
        ObjectId oid = obj.getObjectId();
        Assert.assertEquals((long)3L, (long)obj.getPersistenceState());
        Assert.assertSame((Object)this.context, (Object)obj.getObjectContext());
        Assert.assertSame((Object)obj, (Object)this.context.getGraphManager().getNode(oid));
        this.context.unregisterObjects(Collections.singletonList(obj));
        Assert.assertEquals((long)1L, (long)obj.getPersistenceState());
        Assert.assertNull((Object)obj.getObjectContext());
        Assert.assertNull((Object)obj.getObjectId());
        Assert.assertNull((Object)this.context.getGraphManager().getNode(oid));
        Assert.assertNull((Object)this.context.getObjectStore().getCachedSnapshot(oid));
    }

    @Test
    public void testInvalidateObjects_Vararg() {
        DataRow row = new DataRow(10);
        row.put("ARTIST_ID", new Integer(1));
        row.put("ARTIST_NAME", "ArtistXYZ");
        row.put("DATE_OF_BIRTH", new Date());
        DataObject obj = this.context.objectFromDataRow(Artist.class, row);
        ObjectId oid = obj.getObjectId();
        Assert.assertEquals((long)3L, (long)obj.getPersistenceState());
        Assert.assertSame((Object)this.context, (Object)obj.getObjectContext());
        Assert.assertSame((Object)obj, (Object)this.context.getGraphManager().getNode(oid));
        this.context.invalidateObjects(obj);
        Assert.assertEquals((long)5L, (long)obj.getPersistenceState());
        Assert.assertSame((Object)this.context, (Object)obj.getObjectContext());
        Assert.assertSame((Object)oid, (Object)obj.getObjectId());
        Assert.assertNull((Object)this.context.getObjectStore().getCachedSnapshot(oid));
        Assert.assertNotNull((Object)this.context.getGraphManager().getNode(oid));
    }
}

