/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.Cayenne;
import org.apache.cayenne.FaultFailureException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.UnitTestClosure;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextLocalObjectIT
extends ServerCase {
    @Inject
    private DataContext context1;
    @Inject
    private DataContext context2;
    @Inject
    private DBHelper dbHelper;
    @Inject
    private DataChannelInterceptor interceptor;
    @Inject
    private ServerRuntime runtime;
    private TableHelper tArtist;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
    }

    @Test
    public void testLocalObject_InCache() throws Exception {
        this.tArtist.insert(new Object[]{456, "Bla"});
        final Artist a1 = Cayenne.objectForPK((ObjectContext)this.context1, Artist.class, 456);
        final Artist a2 = Cayenne.objectForPK((ObjectContext)this.context2, Artist.class, 456);
        this.interceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Artist a3 = DataContextLocalObjectIT.this.context2.localObject(a1);
                Assert.assertSame((Object)a3, (Object)a2);
                Assert.assertSame((Object)DataContextLocalObjectIT.this.context2, (Object)a3.getObjectContext());
            }
        });
    }

    @Test
    public void testLocalObject_SameContext() throws Exception {
        this.tArtist.insert(new Object[]{456, "Bla"});
        final Artist a1 = Cayenne.objectForPK((ObjectContext)this.context1, Artist.class, 456);
        this.interceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Artist a2 = DataContextLocalObjectIT.this.context1.localObject(a1);
                Assert.assertSame((Object)a2, (Object)a1);
            }
        });
    }

    @Test
    public void testLocalObject_NotInCache() throws Exception {
        this.tArtist.insert(new Object[]{456, "Bla"});
        final Artist a1 = Cayenne.objectForPK((ObjectContext)this.context1, Artist.class, 456);
        this.interceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Artist a3 = DataContextLocalObjectIT.this.context2.localObject(a1);
                Assert.assertNotSame((Object)a3, (Object)a1);
                Assert.assertEquals((Object)a3.getObjectId(), (Object)a1.getObjectId());
                Assert.assertSame((Object)DataContextLocalObjectIT.this.context2, (Object)a3.getObjectContext());
            }
        });
    }

    @Test
    public void testLocalObject_FFE_InvalidID() throws Exception {
        this.tArtist.insert(new Object[]{777, "AA"});
        Artist a1 = Cayenne.objectForPK((ObjectContext)this.context1, Artist.class, 777);
        Artist a3 = this.context2.localObject(a1);
        Assert.assertEquals((long)5L, (long)a3.getPersistenceState());
        this.context1.invalidateObjects(a1);
        this.tArtist.deleteAll();
        Assert.assertEquals((long)5L, (long)a3.getPersistenceState());
        try {
            a3.getArtistName();
            Assert.fail((String)"FaultFailureException wasn't thrown on attempt to resolve HOLLOW object with no backing DB row");
        }
        catch (FaultFailureException faultFailureException) {
            // empty catch block
        }
    }

    @Test
    public void testLocalObject_TempId() throws Exception {
        final Artist a1 = this.context1.newObject(Artist.class);
        this.interceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Artist a = DataContextLocalObjectIT.this.context2.localObject(a1);
                Assert.assertNotNull((Object)a);
                Assert.assertEquals((Object)a1.getObjectId(), (Object)a.getObjectId());
                try {
                    a.getArtistName();
                    Assert.fail((String)"FaultFailureException wasn't thrown on attempt to resolve HOLLOW object with temp id");
                }
                catch (FaultFailureException faultFailureException) {
                    // empty catch block
                }
            }
        });
    }

    @Test
    public void testLocalObject_TempId_NestedContext() throws Exception {
        final Artist a1 = this.context1.newObject(Artist.class);
        final ObjectContext nestedContext = this.runtime.newContext(this.context1);
        this.interceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Artist a3 = nestedContext.localObject(a1);
                Assert.assertNotSame((Object)a3, (Object)a1);
                Assert.assertEquals((Object)a3.getObjectId(), (Object)a1.getObjectId());
                Assert.assertSame((Object)nestedContext, (Object)a3.getObjectContext());
            }
        });
    }
}

