/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.relationships_flattened.FlattenedTest1;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-relationships-flattened.xml")
public class DataContextEJBQLFlattenedRelationshipsIT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper ft1Helper;
    protected TableHelper ft2Helper;
    protected TableHelper ft3Helper;
    protected TableHelper ft4Helper;

    @Before
    public void setUp() throws Exception {
        this.ft1Helper = new TableHelper(this.dbHelper, "FLATTENED_TEST_1", new String[]{"FT1_ID", "NAME"});
        this.ft2Helper = new TableHelper(this.dbHelper, "FLATTENED_TEST_2");
        this.ft2Helper.setColumns(new String[]{"FT2_ID", "FT1_ID", "NAME"});
        this.ft3Helper = new TableHelper(this.dbHelper, "FLATTENED_TEST_3");
        this.ft3Helper.setColumns(new String[]{"FT3_ID", "FT2_ID", "NAME"});
        this.ft4Helper = new TableHelper(this.dbHelper, "FLATTENED_TEST_4");
        this.ft4Helper.setColumns(new String[]{"FT4_ID", "FT3_ID", "NAME"});
    }

    private void createFt123() throws Exception {
        this.ft1Helper.insert(new Object[]{1, "ft1"}).insert(new Object[]{2, "ft12"});
        this.ft2Helper.insert(new Object[]{1, 1, "ft2"}).insert(new Object[]{2, 2, "ft22"});
        this.ft3Helper.insert(new Object[]{1, 1, "ft3"}).insert(new Object[]{2, 2, "ft3-a"}).insert(new Object[]{3, 2, "ft3-b"});
    }

    private void createFt1234() throws Exception {
        this.createFt123();
        this.ft4Helper.insert(new Object[]{1, 1, "ft4"});
    }

    @Test
    public void testCollectionMemberOfThetaJoin() throws Exception {
        this.createFt123();
        String ejbql = "SELECT f FROM FlattenedTest3 f, FlattenedTest1 ft WHERE f MEMBER OF ft.ft3Array AND ft = :ft";
        FlattenedTest1 ft = Cayenne.objectForPK(this.context, FlattenedTest1.class, 2);
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setParameter("ft", (Object)ft);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(2));
        Assert.assertTrue((boolean)ids.contains(3));
    }

    @Test
    public void testCollectionMemberOfThetaJoinLongRelationshipSequence() throws Exception {
        this.createFt1234();
        String ejbql = "SELECT f FROM FlattenedTest4 f, FlattenedTest1 ft WHERE f MEMBER OF ft.ft4ArrayFor1 AND ft = :ft";
        FlattenedTest1 ft = Cayenne.objectForPK(this.context, FlattenedTest1.class, 1);
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setParameter("ft", (Object)ft);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(new Integer(1)));
        ft = Cayenne.objectForPK(this.context, FlattenedTest1.class, 2);
        query = new EJBQLQuery(ejbql);
        query.setParameter("ft", (Object)ft);
        objects = this.context.performQuery(query);
        Assert.assertEquals((long)0L, (long)objects.size());
    }

    @Test
    public void testCollectionInnerJoin() throws Exception {
        this.createFt123();
        String ejbql = "SELECT ft FROM FlattenedTest1 ft INNER JOIN ft.ft3Array f WHERE ft = :ft";
        FlattenedTest1 ft = Cayenne.objectForPK(this.context, FlattenedTest1.class, 1);
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setParameter("ft", (Object)ft);
        List objects = this.context.performQuery(query);
        Assert.assertNotNull((Object)objects);
        Assert.assertFalse((boolean)objects.isEmpty());
        Assert.assertEquals((long)1L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(new Integer(1)));
    }

    @Test
    public void testCollectionAsInnerJoin() throws Exception {
        this.createFt123();
        String ejbql = "SELECT OBJECT(ft) FROM FlattenedTest1 ft, IN(ft.ft3Array) f WHERE ft = :ft";
        FlattenedTest1 ft = Cayenne.objectForPK(this.context, FlattenedTest1.class, 1);
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setParameter("ft", (Object)ft);
        List objects = this.context.performQuery(query);
        Assert.assertNotNull((Object)objects);
        Assert.assertFalse((boolean)objects.isEmpty());
        Assert.assertEquals((long)1L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(new Integer(1)));
    }

    @Test
    public void testCollectionThetaJoin() throws Exception {
        this.createFt123();
        String ejbql = "SELECT DISTINCT ft FROM FlattenedTest1 ft , FlattenedTest3 f3 WHERE f3.toFT1 = ft";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        Assert.assertNotNull((Object)objects);
        Assert.assertFalse((boolean)objects.isEmpty());
        Assert.assertEquals((long)2L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(new Integer(1)));
        Assert.assertTrue((boolean)ids.contains(new Integer(2)));
    }

    @Test
    public void testCollectionIdentificationVariable() throws Exception {
        this.createFt123();
        String ejbql = "SELECT ft.ft3Array FROM FlattenedTest1 ft WHERE ft = :ft";
        FlattenedTest1 ft = Cayenne.objectForPK(this.context, FlattenedTest1.class, 2);
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setParameter("ft", (Object)ft);
        List objects = this.context.performQuery(query);
        Assert.assertNotNull((Object)objects);
        Assert.assertFalse((boolean)objects.isEmpty());
        Assert.assertEquals((long)2L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(new Integer(2)));
        Assert.assertTrue((boolean)ids.contains(new Integer(3)));
    }

    @Test
    public void testAssociationFieldSelect() throws Exception {
        this.createFt123();
        String ejbql = "SELECT ft3.toFT1 FROM FlattenedTest3 ft3 WHERE ft3.toFT1 = :ft";
        FlattenedTest1 ft = Cayenne.objectForPK(this.context, FlattenedTest1.class, 1);
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setParameter("ft", (Object)ft);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(new Integer(1)));
    }

    @Test
    public void testCollectionSubquery() throws Exception {
        this.createFt123();
        String ejbql = "SELECT ft FROM FlattenedTest1 ft WHERE (SELECT COUNT(f) FROM ft.ft3Array f) = 1";
        EJBQLQuery query = new EJBQLQuery(ejbql);
    }

    @Test
    public void testCollectionSubquery1() throws Exception {
        this.createFt123();
        String ejbql = "SELECT ft FROM FlattenedTest1 ft WHERE (SELECT COUNT(f3) FROM FlattenedTest3 f3 WHERE f3 MEMBER OF ft.ft3Array) > 1";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        Assert.assertNotNull((Object)objects);
        Assert.assertFalse((boolean)objects.isEmpty());
        Assert.assertEquals((long)1L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(new Integer(2)));
    }

    @Test
    public void testGroupByFlattenedRelationship() throws Exception {
        this.createFt123();
        String ejbql = "SELECT COUNT(ft3), ft3.toFT1 FROM FlattenedTest3 ft3  GROUP BY ft3.toFT1 ";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)objects.size());
    }
}

