/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.math.BigDecimal;
import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextEJBQLArrayResultIT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    protected DBHelper dbHelper;

    @Before
    public void setUp() throws Exception {
        TableHelper tArtist = new TableHelper(this.dbHelper, "ARTIST");
        tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        tArtist.insert(new Object[]{33001, "AA1"});
        tArtist.insert(new Object[]{33002, "AA2"});
        tArtist.insert(new Object[]{33003, "BB1"});
        tArtist.insert(new Object[]{33004, "BB2"});
        TableHelper tPainting = new TableHelper(this.dbHelper, "PAINTING");
        tPainting.setColumns(new String[]{"PAINTING_ID", "ARTIST_ID", "PAINTING_TITLE", "ESTIMATED_PRICE"}).setColumnTypes(new int[]{4, -5, 12, 3});
        tPainting.insert(new Object[]{33001, 33001, "P1", 3000});
        tPainting.insert(new Object[]{33002, 33002, "P2", 5000});
        tPainting.insert(new Object[]{33003, null, "P3", 5000});
    }

    @Test
    public void testSQLResultSetMappingScalar() throws Exception {
        String ejbql = "SELECT count(p) FROM Painting p JOIN p.toArtist a";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        Object o1 = objects.get(0);
        Assert.assertEquals((Object)new Long(2L), o1);
    }

    @Test
    public void testSQLResultSetMappingScalars() throws Exception {
        String ejbql = "SELECT count(p), sum(p.estimatedPrice) FROM Painting p JOIN p.toArtist a";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        Object o1 = objects.get(0);
        Assert.assertTrue((String)("Expected Object[]: " + o1), (boolean)(o1 instanceof Object[]));
        Object[] array1 = (Object[])o1;
        Assert.assertEquals((long)2L, (long)array1.length);
        Assert.assertEquals((Object)new Long(2L), (Object)array1[0]);
        Assert.assertEquals((long)0L, (long)new BigDecimal(8000).compareTo((BigDecimal)array1[1]));
    }

    @Test
    public void testSQLResultSetMappingMixed() throws Exception {
        String ejbql = "SELECT count(p), a, sum(p.estimatedPrice) FROM Artist a LEFT JOIN a.paintingArray p GROUP BY a ORDER BY a.artistName";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)4L, (long)objects.size());
        Object o1 = objects.get(0);
        Assert.assertTrue((String)("Expected Object[]: " + o1), (boolean)(o1 instanceof Object[]));
        Object[] array1 = (Object[])o1;
        Assert.assertEquals((long)3L, (long)array1.length);
        Assert.assertEquals((Object)new Long(1L), (Object)array1[0]);
        Assert.assertTrue((String)("Expected Artist, got: " + array1[1]), (boolean)(array1[1] instanceof Artist));
        Assert.assertEquals((long)0L, (long)new BigDecimal(3000).compareTo((BigDecimal)array1[2]));
    }
}

