/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Map;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.dba.frontbase.FrontBaseAdapter;
import org.apache.cayenne.dba.openbase.OpenBaseAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextDecoratedStackIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;

    @Test
    public void testCommitDecorated() {
        DataDomain dd = this.runtime.getDataDomain();
        DataChannelDecorator decorator = new DataChannelDecorator(dd);
        DataContext context = (DataContext)this.runtime.newContext(decorator);
        Artist a = context.newObject(Artist.class);
        a.setArtistName("XXX");
        context.commitChanges();
        SQLTemplate query = new SQLTemplate(Artist.class, "select #result('count(1)' 'int' 'x') from ARTIST");
        query.setFetchingDataRows(true);
        query.setTemplate(FrontBaseAdapter.class.getName(), "select #result('COUNT(ARTIST_ID)' 'int' 'x') from ARTIST");
        query.setTemplate(OpenBaseAdapter.class.getName(), "select #result('COUNT(ARTIST_ID)' 'int' 'x') from ARTIST");
        Map count = (Map)Cayenne.objectForQuery(context, query);
        Assert.assertNotNull((Object)count);
        Assert.assertEquals((Object)new Integer(1), count.get("x"));
    }

    @Test
    public void testGetParentDataDomain() {
        DataDomain dd = this.runtime.getDataDomain();
        DataChannelDecorator decorator = new DataChannelDecorator(dd);
        DataContext context = (DataContext)this.runtime.newContext(decorator);
        Assert.assertSame((Object)dd, (Object)context.getParentDataDomain());
    }

    class DataChannelDecorator
    implements DataChannel {
        protected DataChannel channel;

        protected DataChannelDecorator() {
        }

        public DataChannelDecorator(DataChannel channel) {
            this.setChannel(channel);
        }

        @Override
        public EntityResolver getEntityResolver() {
            return this.channel.getEntityResolver();
        }

        @Override
        public EventManager getEventManager() {
            return this.channel.getEventManager();
        }

        @Override
        public QueryResponse onQuery(ObjectContext originatingContext, Query query) {
            return this.channel.onQuery(originatingContext, query);
        }

        @Override
        public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType) {
            return this.channel.onSync(originatingContext, changes, syncType);
        }

        public DataChannel getChannel() {
            return this.channel;
        }

        public void setChannel(DataChannel channel) {
            this.channel = channel;
        }
    }
}

