/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.compound.CompoundFkTestEntity;
import org.apache.cayenne.testdo.compound.CompoundPkTestEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-compound.xml")
public class DataContextCompoundRelIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DataContext context1;

    @Test
    public void testInsert() {
        CompoundPkTestEntity master = this.context.newObject(CompoundPkTestEntity.class);
        CompoundFkTestEntity detail = this.context.newObject(CompoundFkTestEntity.class);
        master.addToCompoundFkArray(detail);
        master.setName("m1");
        master.setKey1("key11");
        master.setKey2("key21");
        detail.setName("d1");
        this.context.commitChanges();
        this.context.invalidateObjects(master, detail);
        SelectQuery<CompoundPkTestEntity> q = new SelectQuery<CompoundPkTestEntity>(CompoundPkTestEntity.class);
        List objs = this.context1.performQuery(q);
        Assert.assertEquals((long)1L, (long)objs.size());
        master = (CompoundPkTestEntity)objs.get(0);
        Assert.assertEquals((Object)"m1", (Object)master.getName());
        List<CompoundFkTestEntity> details = master.getCompoundFkArray();
        Assert.assertEquals((long)1L, (long)details.size());
        detail = details.get(0);
        Assert.assertEquals((Object)"d1", (Object)detail.getName());
    }

    @Test
    public void testFetchQualifyingToOne() {
        CompoundPkTestEntity master = (CompoundPkTestEntity)this.context.newObject("CompoundPkTestEntity");
        CompoundPkTestEntity master1 = (CompoundPkTestEntity)this.context.newObject("CompoundPkTestEntity");
        CompoundFkTestEntity detail = (CompoundFkTestEntity)this.context.newObject("CompoundFkTestEntity");
        CompoundFkTestEntity detail1 = (CompoundFkTestEntity)this.context.newObject("CompoundFkTestEntity");
        master.addToCompoundFkArray(detail);
        master1.addToCompoundFkArray(detail1);
        master.setName("m1");
        master.setKey1("key11");
        master.setKey2("key21");
        master1.setName("m2");
        master1.setKey1("key12");
        master1.setKey2("key22");
        detail.setName("d1");
        detail1.setName("d2");
        this.context.commitChanges();
        this.context.invalidateObjects(master, master1, detail, detail1);
        Expression qual = ExpressionFactory.matchExp("toCompoundPk", master);
        SelectQuery<CompoundFkTestEntity> q = new SelectQuery<CompoundFkTestEntity>(CompoundFkTestEntity.class, qual);
        List objs = this.context1.performQuery(q);
        Assert.assertEquals((long)1L, (long)objs.size());
        detail = (CompoundFkTestEntity)objs.get(0);
        Assert.assertEquals((Object)"d1", (Object)detail.getName());
    }

    @Test
    public void testFetchQualifyingToMany() throws Exception {
        CompoundPkTestEntity master = (CompoundPkTestEntity)this.context.newObject("CompoundPkTestEntity");
        CompoundPkTestEntity master1 = (CompoundPkTestEntity)this.context.newObject("CompoundPkTestEntity");
        CompoundFkTestEntity detail = (CompoundFkTestEntity)this.context.newObject("CompoundFkTestEntity");
        CompoundFkTestEntity detail1 = (CompoundFkTestEntity)this.context.newObject("CompoundFkTestEntity");
        master.addToCompoundFkArray(detail);
        master1.addToCompoundFkArray(detail1);
        master.setName("m1");
        master.setKey1("key11");
        master.setKey2("key21");
        master1.setName("m2");
        master1.setKey1("key12");
        master1.setKey2("key22");
        detail.setName("d1");
        detail1.setName("d2");
        this.context.commitChanges();
        this.context.invalidateObjects(master, master1, detail, detail1);
        Expression qual = ExpressionFactory.matchExp("compoundFkArray", detail1);
        SelectQuery<CompoundPkTestEntity> q = new SelectQuery<CompoundPkTestEntity>(CompoundPkTestEntity.class, qual);
        List objs = this.context1.performQuery(q);
        Assert.assertEquals((long)1L, (long)objs.size());
        master = (CompoundPkTestEntity)objs.get(0);
        Assert.assertEquals((Object)"m2", (Object)master.getName());
    }
}

