/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.testdo.compound.CharPkTestEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-compound.xml")
public class DataContextCharPKIT
extends ServerCase {
    @Inject
    private DataContext context;

    @Test
    public void testInsert() throws Exception {
        CharPkTestEntity object = this.context.newObject(CharPkTestEntity.class);
        object.setOtherCol("object-XYZ");
        object.setPkCol("PK1");
        this.context.commitChanges();
        SQLTemplate q = new SQLTemplate(CharPkTestEntity.class, "SELECT * FROM CHAR_PK_TEST");
        q.setFetchingDataRows(true);
        List rows = this.context.performQuery(q);
        Assert.assertNotNull((Object)rows);
        Assert.assertEquals((long)1L, (long)rows.size());
        DataRow row = (DataRow)rows.get(0);
        Object val = row.get("OTHER_COL");
        if (val == null) {
            val = row.get("other_col");
        }
        Assert.assertEquals((Object)"object-XYZ", val);
        val = row.get("PK_COL");
        if (val == null) {
            val = row.get("pk_col");
        }
        Assert.assertEquals((Object)"PK1", val);
    }

    @Test
    public void testDelete() throws Exception {
        CharPkTestEntity object = this.context.newObject(CharPkTestEntity.class);
        object.setOtherCol("object-XYZ");
        object.setPkCol("PK1");
        this.context.commitChanges();
        this.context.deleteObjects(object);
        this.context.commitChanges();
        SQLTemplate q = new SQLTemplate(CharPkTestEntity.class, "SELECT * FROM CHAR_PK_TEST");
        q.setFetchingDataRows(true);
        List rows = this.context.performQuery(q);
        Assert.assertNotNull((Object)rows);
        Assert.assertEquals((long)0L, (long)rows.size());
    }

    @Test
    public void testUpdate() throws Exception {
        CharPkTestEntity object = this.context.newObject(CharPkTestEntity.class);
        object.setOtherCol("object-XYZ");
        object.setPkCol("PK1");
        this.context.commitChanges();
        object.setOtherCol("UPDATED");
        this.context.commitChanges();
        SQLTemplate q = new SQLTemplate(CharPkTestEntity.class, "SELECT * FROM CHAR_PK_TEST");
        q.setFetchingDataRows(true);
        List rows = this.context.performQuery(q);
        Assert.assertNotNull((Object)rows);
        Assert.assertEquals((long)1L, (long)rows.size());
        DataRow row = (DataRow)rows.get(0);
        Object val = row.get("OTHER_COL");
        if (val == null) {
            val = row.get("other_col");
        }
        Assert.assertEquals((Object)"UPDATED", val);
    }
}

