/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.binary_pk.BinaryPKTest1;
import org.apache.cayenne.testdo.binary_pk.BinaryPKTest2;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-binary-pk.xml")
public class DataContextBinaryPKIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DataContext context1;
    @Inject
    private UnitDbAdapter accessStackAdapter;

    @Test
    public void testInsertBinaryPK() throws Exception {
        if (this.accessStackAdapter.supportsBinaryPK()) {
            BinaryPKTest1 master = (BinaryPKTest1)this.context.newObject("BinaryPKTest1");
            master.setName("master1");
            BinaryPKTest2 detail = (BinaryPKTest2)this.context.newObject("BinaryPKTest2");
            detail.setDetailName("detail2");
            master.addToBinaryPKDetails(detail);
            this.context.commitChanges();
        }
    }

    @Test
    public void testFetchRelationshipBinaryPK() throws Exception {
        if (this.accessStackAdapter.supportsBinaryPK()) {
            BinaryPKTest1 master = (BinaryPKTest1)this.context.newObject("BinaryPKTest1");
            master.setName("master1");
            BinaryPKTest2 detail = (BinaryPKTest2)this.context.newObject("BinaryPKTest2");
            detail.setDetailName("detail2");
            master.addToBinaryPKDetails(detail);
            this.context.commitChanges();
            this.context.invalidateObjects(master, detail);
            BinaryPKTest2 fetchedDetail = (BinaryPKTest2)this.context1.performQuery(new SelectQuery<BinaryPKTest2>(BinaryPKTest2.class)).get(0);
            Assert.assertNotNull((Object)fetchedDetail.readPropertyDirectly("toBinaryPKMaster"));
            BinaryPKTest1 fetchedMaster = fetchedDetail.getToBinaryPKMaster();
            Assert.assertNotNull((Object)fetchedMaster);
            Assert.assertEquals((long)5L, (long)fetchedMaster.getPersistenceState());
            Assert.assertEquals((Object)"master1", (Object)fetchedMaster.getName());
        }
    }
}

