/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.access.ClientServerChannel;
import org.apache.cayenne.access.IncrementalFaultList;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.EntityResultSegment;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.util.GenericResponse;
import org.apache.cayenne.util.IncrementalListResponse;
import org.apache.cayenne.util.ListResponse;
import org.apache.cayenne.util.ObjectDetachOperation;

class ClientServerChannelQueryAction {
    static final boolean DONE = true;
    private final ClientServerChannel channel;
    private Query serverQuery;
    private QueryResponse response;
    private final QueryMetadata serverMetadata;
    private final EntityResolver serverResolver;

    ClientServerChannelQueryAction(ClientServerChannel channel, Query query) {
        this.channel = channel;
        this.serverResolver = channel.getEntityResolver();
        this.serverQuery = query;
        this.serverMetadata = this.serverQuery.getMetaData(this.serverResolver);
    }

    QueryResponse execute() {
        if (!this.interceptSinglePageQuery()) {
            this.runQuery();
        }
        if (!this.interceptIncrementalListConversion()) {
            this.interceptObjectConversion();
        }
        return this.response;
    }

    private boolean interceptSinglePageQuery() {
        if (this.serverMetadata.getFetchOffset() >= 0 && this.serverMetadata.getFetchLimit() > 0 && this.serverMetadata.getCacheKey() != null) {
            List cachedList = this.channel.getQueryCache().get(this.serverMetadata);
            if (cachedList == null) {
                Query originatingQuery = this.serverMetadata.getOrginatingQuery();
                if (originatingQuery != null) {
                    ClientServerChannelQueryAction subaction = new ClientServerChannelQueryAction(this.channel, originatingQuery);
                    subaction.execute();
                    cachedList = this.channel.getQueryCache().get(this.serverMetadata);
                }
                if (cachedList == null) {
                    throw new CayenneRuntimeException("No cached list for " + this.serverMetadata.getCacheKey(), new Object[0]);
                }
            }
            int startIndex = this.serverMetadata.getFetchOffset();
            int endIndex = startIndex + this.serverMetadata.getFetchLimit();
            this.response = new ListResponse(new ArrayList(cachedList.subList(startIndex, endIndex)));
            return true;
        }
        return false;
    }

    private void runQuery() {
        this.response = this.channel.getParentChannel().onQuery(null, this.serverQuery);
    }

    private boolean interceptIncrementalListConversion() {
        List list;
        int pageSize = this.serverMetadata.getPageSize();
        if (pageSize > 0 && this.serverMetadata.getCacheKey() != null && (list = this.response.firstList()).size() > pageSize && list instanceof IncrementalFaultList) {
            this.channel.getQueryCache().put(this.serverMetadata, list);
            List sublist = list.subList(0, pageSize);
            List firstPage = this.serverMetadata.isFetchingDataRows() ? new ArrayList(sublist) : this.toClientObjects(sublist);
            this.response = new IncrementalListResponse(firstPage, list.size());
            return true;
        }
        return false;
    }

    private void interceptObjectConversion() {
        if (!this.serverMetadata.isFetchingDataRows()) {
            GenericResponse clientResponse = new GenericResponse();
            this.response.reset();
            while (this.response.next()) {
                if (this.response.isList()) {
                    List<?> serverObjects = this.response.currentList();
                    clientResponse.addResultList(this.toClientObjects(serverObjects));
                    continue;
                }
                clientResponse.addBatchUpdateCount(this.response.currentUpdateCount());
            }
            this.response = clientResponse;
        }
    }

    private List toClientObjects(List serverObjects) {
        if (!serverObjects.isEmpty()) {
            List<Object> rsMapping = this.serverMetadata.getResultSetMapping();
            if (rsMapping == null) {
                return this.singleObjectConversion(serverObjects);
            }
            if (rsMapping.size() == 1) {
                if (rsMapping.get(0) instanceof EntityResultSegment) {
                    return this.singleObjectConversion(serverObjects);
                }
                return serverObjects;
            }
            return this.processMixedResult(serverObjects, rsMapping);
        }
        return new ArrayList(3);
    }

    private List<Object[]> processMixedResult(List<Object[]> serverObjects, List<Object> rsMapping) {
        ArrayList<Object[]> clientObjects = new ArrayList<Object[]>(serverObjects.size());
        ObjectDetachOperation op = new ObjectDetachOperation(this.serverResolver.getClientEntityResolver());
        int width = rsMapping.size();
        for (Object[] serverObject : serverObjects) {
            Object[] clientObject = new Object[width];
            for (int i = 0; i < width; ++i) {
                clientObject[i] = rsMapping.get(i) instanceof EntityResultSegment ? this.convertSingleObject(this.serverMetadata.getPrefetchTree(), op, serverObject[i]) : serverObject[i];
            }
            clientObjects.add(clientObject);
        }
        return clientObjects;
    }

    private List<?> singleObjectConversion(List<?> serverObjects) {
        ArrayList<Object> clientObjects = new ArrayList<Object>(serverObjects.size());
        ObjectDetachOperation op = new ObjectDetachOperation(this.serverResolver.getClientEntityResolver());
        PrefetchTreeNode prefetchTree = this.serverMetadata.getPrefetchTree();
        for (Object serverObject : serverObjects) {
            clientObjects.add(this.convertSingleObject(prefetchTree, op, serverObject));
        }
        return clientObjects;
    }

    private Object convertSingleObject(PrefetchTreeNode prefetchTree, ObjectDetachOperation op, Object serverObject) {
        Persistent object = (Persistent)serverObject;
        ObjectId id = object.getObjectId();
        if (id == null) {
            throw new CayenneRuntimeException("Server returned an object without an id: " + object, new Object[0]);
        }
        ClassDescriptor serverDescriptor = this.serverResolver.getClassDescriptor(id.getEntityName());
        return op.detach(object, serverDescriptor, prefetchTree);
    }
}

