/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.util.GenericResponse;

public class MockDataChannel
implements DataChannel {
    protected EntityResolver resolver;
    protected List requestObjects = new ArrayList();
    protected GraphDiff commitResponse;
    protected QueryResponse response;

    public MockDataChannel() {
    }

    public MockDataChannel(GraphDiff commitResponse) {
        this.commitResponse = commitResponse;
    }

    public MockDataChannel(List selectResponse) {
        this.response = new GenericResponse(selectResponse);
    }

    public MockDataChannel(EntityResolver entityResolver, List selectResponse) {
        this(selectResponse);
        this.resolver = entityResolver;
    }

    public MockDataChannel(EntityResolver entityResolver, QueryResponse response) {
        this.resolver = entityResolver;
        this.response = response;
    }

    public MockDataChannel(EntityResolver resolver) {
        this(resolver, new GenericResponse());
    }

    @Override
    public EventManager getEventManager() {
        return null;
    }

    public void reset() {
        this.requestObjects.clear();
    }

    public List getRequestObjects() {
        return this.requestObjects;
    }

    @Override
    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType) {
        this.requestObjects.add(changes);
        return this.commitResponse;
    }

    @Override
    public QueryResponse onQuery(ObjectContext context, Query query) {
        this.requestObjects.add(query);
        return this.response;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.resolver;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.resolver = resolver;
    }
}

